/*
 * Decompiled with CFR 0.152.
 */
package javax.security.jacc;

import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.security.jacc.WebResourcePermission;

public final class WebResourcePermissionCollection
extends PermissionCollection {
    private Hashtable permissions = new Hashtable();

    public void add(Permission permission) {
        if (this.isReadOnly()) {
            throw new IllegalArgumentException("Read only collection");
        }
        if (!(permission instanceof WebResourcePermission)) {
            throw new IllegalArgumentException("Wrong permission type");
        }
        WebResourcePermission p = (WebResourcePermission)permission;
        this.permissions.put(p, p);
    }

    public boolean implies(Permission permission) {
        if (!(permission instanceof WebResourcePermission)) {
            return false;
        }
        WebResourcePermission p = (WebResourcePermission)permission;
        Enumeration enumeration = this.permissions.elements();
        while (enumeration.hasMoreElements()) {
            if (!((WebResourcePermission)enumeration.nextElement()).implies(p)) continue;
            return true;
        }
        return false;
    }

    public Enumeration elements() {
        return this.permissions.elements();
    }
}

