/*
 * Decompiled with CFR 0.152.
 */
package javax.security.jacc;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.PrivilegedAction;
import javax.security.jacc.EJBMethodPermissionCollection;

public final class EJBMethodPermission
extends Permission {
    private static final String NEW_METHOD_INTERFACES = "org.apache.security.jacc.EJBMethodPermission.methodInterfaces";
    private static String[] methodInterfaces;
    private transient int cachedHashCode;
    protected transient MethodSpec methodSpec;

    public EJBMethodPermission(String name, String spec) {
        super(name);
        this.methodSpec = new MethodSpec(spec);
    }

    public EJBMethodPermission(String EJBName, String methodName, String methodInterface, String[] methodParams) {
        super(EJBName);
        this.methodSpec = new MethodSpec(methodName, methodInterface, methodParams);
    }

    public EJBMethodPermission(String EJBName, String methodInterface, Method method) {
        super(EJBName);
        if (method == null) {
            throw new IllegalArgumentException("Parameter method must not be null");
        }
        this.methodSpec = new MethodSpec(methodInterface, method);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof EJBMethodPermission)) {
            return false;
        }
        EJBMethodPermission other = (EJBMethodPermission)o;
        return this.getName().equals(other.getName()) && this.methodSpec.equals(other.methodSpec);
    }

    public String getActions() {
        return this.methodSpec.getActions();
    }

    public int hashCode() {
        if (this.cachedHashCode == 0) {
            this.cachedHashCode = this.getName().hashCode() ^ this.methodSpec.hashCode();
        }
        return this.cachedHashCode;
    }

    public boolean implies(Permission permission) {
        if (permission == null || !(permission instanceof EJBMethodPermission)) {
            return false;
        }
        EJBMethodPermission other = (EJBMethodPermission)permission;
        return this.getName().equals(other.getName()) && this.methodSpec.implies(other.methodSpec);
    }

    public PermissionCollection newPermissionCollection() {
        return new EJBMethodPermissionCollection();
    }

    private synchronized void readObject(ObjectInputStream in) throws IOException {
        this.methodSpec = new MethodSpec(in.readUTF());
    }

    private synchronized void writeObject(ObjectOutputStream out) throws IOException {
        out.writeUTF(this.methodSpec.getActions());
    }

    static {
        String newMethodInterfaces = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(EJBMethodPermission.NEW_METHOD_INTERFACES);
            }
        });
        newMethodInterfaces = newMethodInterfaces != null ? newMethodInterfaces + ",Home,LocalHome,Remote,Local,ServiceEndpoint" : "Home,LocalHome,Remote,Local,ServiceEndpoint";
        methodInterfaces = newMethodInterfaces.split(",", -1);
    }

    protected class MethodSpec {
        protected String methodName;
        protected String methodInterface;
        protected String methodParams;
        protected String actions;

        public MethodSpec(String actionString) {
            if (actionString == null || actionString.length() == 0) {
                this.methodName = null;
                this.methodInterface = null;
                this.methodParams = null;
                this.actions = "";
            } else {
                String[] tokens = actionString.split(",", 3);
                switch (tokens.length) {
                    case 1: {
                        this.methodName = this.emptyNullCheck(tokens[0]);
                        this.methodInterface = null;
                        this.methodParams = null;
                        break;
                    }
                    case 2: {
                        if (tokens[1].length() == 0) {
                            throw new IllegalArgumentException("This format of actions requires a method interface");
                        }
                        this.checkMethodInterface(tokens[1]);
                        this.methodName = this.emptyNullCheck(tokens[0]);
                        this.methodInterface = this.emptyNullCheck(tokens[1]);
                        this.methodParams = null;
                        break;
                    }
                    case 3: {
                        this.checkMethodInterface(tokens[1]);
                        if (tokens[2].indexOf(44) > -1) {
                            String[] test = tokens[2].split(",", -1);
                            for (int i = 0; i < test.length; ++i) {
                                if (test[i].length() != 0) continue;
                                throw new IllegalArgumentException("Invalid type name");
                            }
                        }
                        this.methodName = this.emptyNullCheck(tokens[0]);
                        this.methodInterface = this.emptyNullCheck(tokens[1]);
                        this.methodParams = tokens[2];
                    }
                }
                this.actions = actionString;
            }
        }

        public MethodSpec(String mthdName, String mthdInterface, String[] methodParamsArray) {
            this.checkMethodInterface(mthdInterface);
            this.methodName = this.emptyNullCheck(mthdName);
            this.methodInterface = this.emptyNullCheck(mthdInterface);
            if (methodParamsArray == null) {
                this.methodParams = null;
            } else if (methodParamsArray.length == 0) {
                this.methodParams = "";
            } else {
                if (methodParamsArray[0] == null || methodParamsArray[0].length() == 0) {
                    throw new IllegalArgumentException("Invalid type name");
                }
                StringBuffer buffer = new StringBuffer(methodParamsArray[0]);
                for (int i = 1; i < methodParamsArray.length; ++i) {
                    if (methodParamsArray[i] == null || methodParamsArray[i].length() == 0) {
                        throw new IllegalArgumentException("Invalid type name");
                    }
                    buffer.append(",");
                    buffer.append(methodParamsArray[i]);
                }
                this.methodParams = buffer.toString();
            }
            this.initActions();
        }

        public MethodSpec(String mthdInterface, Method method) {
            this.checkMethodInterface(mthdInterface);
            this.methodName = method.getName();
            this.methodInterface = this.emptyNullCheck(mthdInterface);
            Class<?>[] paramTypes = method.getParameterTypes();
            if (paramTypes.length == 0) {
                this.methodParams = "";
            } else {
                StringBuffer buffer = new StringBuffer(paramTypes[0].getName());
                for (int i = 1; i < paramTypes.length; ++i) {
                    buffer.append(",");
                    buffer.append(paramTypes[i].getName());
                }
                this.methodParams = buffer.toString();
            }
            this.initActions();
        }

        public boolean equals(MethodSpec spec) {
            return this.implies(spec) && spec.implies(this);
        }

        public String getActions() {
            return this.actions;
        }

        public int hashCode() {
            return this.actions.hashCode();
        }

        public boolean implies(MethodSpec methodSpec) {
            if (this.methodName == null || this.methodName.equals(methodSpec.methodName)) {
                if (this.methodInterface == null || this.methodInterface.equals(methodSpec.methodInterface)) {
                    return this.methodParams == null || this.methodParams.equals(methodSpec.methodParams);
                }
                return false;
            }
            return false;
        }

        private void initActions() {
            this.actions = this.methodParams == null ? (this.methodInterface == null ? (this.methodName == null ? ",," : this.methodName) : (this.methodName == null ? "," + this.methodInterface : this.methodName + "," + this.methodInterface)) : (this.methodInterface == null ? (this.methodName == null ? ",," + this.methodParams : this.methodName + ",," + this.methodParams) : (this.methodName == null ? "," + this.methodInterface + "," + this.methodParams : this.methodName + "," + this.methodInterface + "," + this.methodParams));
        }

        private void checkMethodInterface(String methodInterface) {
            if (methodInterface == null || methodInterface.length() == 0) {
                return;
            }
            for (int i = 0; i < methodInterfaces.length; ++i) {
                if (!methodInterfaces[i].equals(methodInterface)) continue;
                return;
            }
            throw new IllegalArgumentException("Invalid method interface");
        }

        private String emptyNullCheck(String name) {
            if (name != null && name.length() == 0) {
                return null;
            }
            return name;
        }
    }
}

