/*
 * Decompiled with CFR 0.152.
 */
package fr.brouillard.oss.jgitver.impl;

import java.io.IOException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.errors.NoWorkTreeException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;

public class GitUtils {
    private static final String BRANCH_SYSTEM_PROPERTY = "jgitver.branch";
    private static final String BRANCH_ENV_VARIABLE = "JGITVER_BRANCH";

    public static String tagNameFromRef(Ref tag) {
        return tag.getName().replace("refs/tags/", "");
    }

    public static boolean isAnnotated(Ref ref) {
        return ref != null && ref.getPeeledObjectId() != null;
    }

    public static String sanitizeBranchName(String currentBranch) {
        return currentBranch.replaceAll("[\\s\\-#/\\\\]+", "_");
    }

    public static boolean isDetachedHead(Repository repository) throws IOException {
        return repository.getFullBranch().matches("[0-9a-f]{40}");
    }

    public static List<Ref> tagsOf(List<Ref> tags, ObjectId id) {
        return tags.stream().filter(ref -> id.equals((AnyObjectId)ref.getObjectId()) || id.equals((AnyObjectId)ref.getPeeledObjectId())).collect(Collectors.toList());
    }

    public static boolean isDirty(Git git) throws NoWorkTreeException, GitAPIException {
        Status status = git.status().call();
        return !status.isClean();
    }

    public static String getTimestamp(Instant commitInstant) {
        LocalDateTime commitDateTime = LocalDateTime.ofInstant(commitInstant, ZoneId.systemDefault());
        String isoDateTime = DateTimeFormatter.ISO_LOCAL_DATE_TIME.format(commitDateTime);
        return isoDateTime.replace("-", "").replace(":", "").replace("T", "");
    }

    public static Optional<String> providedBranchName() {
        return Optional.ofNullable(System.getProperty(BRANCH_SYSTEM_PROPERTY, System.getenv(BRANCH_ENV_VARIABLE)));
    }
}

