/*
 * Decompiled with CFR 0.152.
 */
package fr.brouillard.oss.jgitver;

import fr.brouillard.oss.jgitver.GAV;
import fr.brouillard.oss.jgitver.JGitverInformationProvider;
import fr.brouillard.oss.jgitver.JGitverMavenPluginProperties;
import fr.brouillard.oss.jgitver.metadata.Metadatas;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public final class JGitverUtils {
    public static final String EXTENSION_PREFIX = "jgitver";
    public static final String EXTENSION_GROUP_ID = "fr.brouillard.oss";
    public static final String EXTENSION_ARTIFACT_ID = "jgitver-maven-plugin";
    public static final String EXTENSION_SKIP = "jgitver.skip";
    public static final String EXTENSION_FLATTEN = "jgitver.flatten";
    public static final String EXTENSION_USE_VERSION = "jgitver.use-version";
    public static final String SESSION_MAVEN_PROPERTIES_KEY = "jgitver.session";

    private JGitverUtils() {
    }

    public static Model loadInitialModel(File pomFile) throws IOException, XmlPullParserException {
        try (FileReader fileReader = new FileReader(pomFile);){
            Model model = new MavenXpp3Reader().read((Reader)fileReader);
            return model;
        }
    }

    public static File createPomDumpFile() throws IOException {
        File tmp = File.createTempFile("pom", ".jgitver-maven-plugin.xml");
        tmp.deleteOnExit();
        return tmp;
    }

    public static void writeModelPom(Model mavenModel, File pomFile) throws IOException {
        try (FileWriter fileWriter = new FileWriter(pomFile);){
            new MavenXpp3Writer().write((Writer)fileWriter, mavenModel);
        }
    }

    public static void changeBaseDir(MavenProject project, File initialBaseDir) throws NoSuchFieldException, IllegalAccessException {
        Field basedirField = project.getClass().getField("basedir");
        basedirField.setAccessible(true);
        basedirField.set(project, initialBaseDir);
    }

    public static void setProjectPomFile(MavenProject project, File newPom, Logger logger) {
        try {
            project.setPomFile(newPom);
        }
        catch (Throwable unused) {
            logger.warn("maven version might be <= 3.2.4, changing pom file using old mechanism");
            File initialBaseDir = project.getBasedir();
            project.setFile(newPom);
            File newBaseDir = project.getBasedir();
            try {
                if (!initialBaseDir.getCanonicalPath().equals(newBaseDir.getCanonicalPath())) {
                    JGitverUtils.changeBaseDir(project, initialBaseDir);
                }
            }
            catch (Exception ex) {
                GAV gav = GAV.from(project);
                logger.warn("cannot reset basedir of project " + gav.toString(), (Throwable)ex);
            }
        }
    }

    public static void fillPropertiesFromMetadatas(Properties properties, JGitverInformationProvider informationProvider, Logger logger) {
        String calculatedVersion = informationProvider.getVersion();
        logger.debug("jgitver calculated version number: " + calculatedVersion);
        properties.put("jgitver.used_version", calculatedVersion);
        properties.put("jgitver.plugin-version", JGitverMavenPluginProperties.getVersion());
        Arrays.asList(Metadatas.values()).stream().forEach(metaData -> {
            Optional metaValue = informationProvider.meta((Metadatas)metaData);
            String propertyName = "jgitver." + metaData.name().toLowerCase(Locale.ENGLISH);
            String value = metaValue.orElse("");
            properties.put(propertyName, value);
            logger.debug("setting property " + propertyName + " with \"" + value + "\"");
        });
    }

    public static void attachModifiedPomFilesToTheProject(List<MavenProject> projects, Set<GAV> gavs, String version, Logger logger) throws IOException, XmlPullParserException {
        for (MavenProject project : projects) {
            GAV parentGAV;
            Model model = JGitverUtils.loadInitialModel(project.getFile());
            GAV initalProjectGAV = GAV.from(model);
            logger.debug("about to change file pom for: " + initalProjectGAV);
            if (gavs.contains(initalProjectGAV)) {
                model.setVersion(version);
                if (model.getScm() != null && project.getModel().getScm() != null) {
                    model.getScm().setTag(project.getModel().getScm().getTag());
                }
            }
            if (model.getParent() != null && gavs.contains(parentGAV = GAV.from(model.getParent()))) {
                model.getParent().setVersion(version);
            }
            File newPom = JGitverUtils.createPomDumpFile();
            JGitverUtils.writeModelPom(model, newPom);
            logger.debug("    new pom file created for " + initalProjectGAV + " under " + newPom);
            JGitverUtils.setProjectPomFile(project, newPom, logger);
            logger.debug("    pom file set");
        }
    }

    public static void failAsOldMechanism(Consumer<? super CharSequence> logger) throws MavenExecutionException {
        logger.accept("jgitver has changed!");
        logger.accept("");
        logger.accept("it now requires the usage of maven core extensions (> 3.3.1) instead of standard plugin extensions.");
        logger.accept("The plugin must be now declared in a `.mvn/extensions.xml` file.");
        logger.accept("");
        logger.accept("    read https://github.com/jgitver/jgitver-maven-plugin for further information");
        logger.accept("");
        throw new MavenExecutionException("detection of jgitver old setting mechanism", (Throwable)new IllegalStateException("jgitver must now use maven core extensions only"));
    }

    public static boolean shouldSkip(MavenSession session) {
        return Boolean.parseBoolean(session.getSystemProperties().getProperty(EXTENSION_SKIP, "false")) || Boolean.parseBoolean(session.getUserProperties().getProperty(EXTENSION_SKIP, "false"));
    }

    public static boolean shouldUseFlattenPlugin(MavenSession session) {
        return Boolean.parseBoolean(session.getSystemProperties().getProperty(EXTENSION_FLATTEN, "false")) || Boolean.parseBoolean(session.getUserProperties().getProperty(EXTENSION_FLATTEN, "false"));
    }

    public static Optional<String> versionOverride(MavenSession session) {
        return Optional.ofNullable(session.getSystemProperties().getProperty(EXTENSION_USE_VERSION));
    }

    public static interface CLI {
        public static final String OVERRIDE_CONFIG_FILE = "jgitver.config";
    }
}

