/*
 * Decompiled with CFR 0.152.
 */
package fr.brouillard.oss.jgitver;

import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.project.MavenProject;

public class GAV {
    private String groupId;
    private String artifactId;
    private String version;

    public GAV() {
    }

    public GAV(String groupId, String artifactId, String version) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public static GAV from(MavenProject project) {
        return new GAV(project.getGroupId(), project.getArtifactId(), project.getVersion());
    }

    public static GAV from(Model model) {
        String groupId;
        String string = model.getGroupId() != null ? model.getGroupId() : (groupId = model.getParent() != null ? model.getParent().getGroupId() : null);
        String version = model.getVersion() != null ? model.getVersion() : (model.getParent() != null ? model.getParent().getVersion() : null);
        return new GAV(groupId, model.getArtifactId(), version);
    }

    public static GAV from(Parent parent) {
        return new GAV(parent.getGroupId(), parent.getArtifactId(), parent.getVersion());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.artifactId == null ? 0 : this.artifactId.hashCode());
        result = 31 * result + (this.groupId == null ? 0 : this.groupId.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GAV other = (GAV)obj;
        if (this.artifactId == null ? other.artifactId != null : !this.artifactId.equals(other.artifactId)) {
            return false;
        }
        if (this.groupId == null ? other.groupId != null : !this.groupId.equals(other.groupId)) {
            return false;
        }
        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
    }

    public String toString() {
        return String.format("%s::%s::%s", this.groupId, this.artifactId, this.version);
    }
}

