/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.arquillian.shaded.jvnet.hk2.internal;

import fish.payara.arquillian.shaded.glassfish.hk2.api.ActiveDescriptor;
import fish.payara.arquillian.shaded.glassfish.hk2.api.Injectee;
import fish.payara.arquillian.shaded.glassfish.hk2.api.InjectionResolver;
import fish.payara.arquillian.shaded.glassfish.hk2.api.MultiException;
import fish.payara.arquillian.shaded.glassfish.hk2.api.ServiceHandle;
import fish.payara.arquillian.shaded.glassfish.hk2.api.UnsatisfiedDependencyException;
import fish.payara.arquillian.shaded.jakarta.inject.Inject;
import fish.payara.arquillian.shaded.jakarta.inject.Named;
import fish.payara.arquillian.shaded.jvnet.hk2.internal.ServiceLocatorImpl;

@Named(value="SystemInjectResolver")
public class ThreeThirtyResolver
implements InjectionResolver<Inject> {
    private final ServiceLocatorImpl locator;

    ThreeThirtyResolver(ServiceLocatorImpl locator) {
        this.locator = locator;
    }

    @Override
    public Object resolve(Injectee injectee, ServiceHandle<?> root) {
        ActiveDescriptor<?> ad = this.locator.getInjecteeDescriptor(injectee);
        if (ad == null) {
            if (injectee.isOptional()) {
                return null;
            }
            throw new MultiException(new UnsatisfiedDependencyException(injectee, this.locator.getName()));
        }
        return this.locator.getService(ad, root, injectee);
    }

    @Override
    public boolean isConstructorParameterIndicator() {
        return false;
    }

    @Override
    public boolean isMethodParameterIndicator() {
        return false;
    }

    public String toString() {
        return "ThreeThirtyResolver(" + this.locator + "," + System.identityHashCode(this) + ")";
    }
}

