/*
 * Decompiled with CFR 0.152.
 */
package eu.trojanbug.maven.plugins;

import eu.trojanbug.maven.plugins.types.PropertyDescription;
import eu.trojanbug.maven.plugins.types.PropertyMapping;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineUtils;

public class MapPropertiesMojo
extends AbstractMojo {
    private MavenProject project;
    private PropertyMapping[] mappings;
    private String environmentVarablesPrefix;
    private String systemPropertiesPrefix;
    private static final String aMagicStringImpossibleToMatchAccidentally = "BB6F4E922689696FED9EC8A5F6DB808C";

    public void execute() throws MojoExecutionException {
        Map.Entry entry;
        Iterator iter;
        Properties projectProperties = this.project.getProperties();
        Properties mergedProperties = new Properties();
        if (StringUtils.isNotEmpty((String)this.environmentVarablesPrefix)) {
            try {
                Properties environment = CommandLineUtils.getSystemEnvVars();
                iter = ((Hashtable)environment).entrySet().iterator();
                while (iter.hasNext()) {
                    entry = iter.next();
                    ((Hashtable)mergedProperties).put(this.environmentVarablesPrefix + entry.getKey(), entry.getValue());
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        if (StringUtils.isNotEmpty((String)this.systemPropertiesPrefix)) {
            Properties systemProps = System.getProperties();
            iter = ((Hashtable)systemProps).entrySet().iterator();
            while (iter.hasNext()) {
                entry = iter.next();
                ((Hashtable)mergedProperties).put(this.systemPropertiesPrefix + entry.getKey(), entry.getValue());
            }
        }
        ((Hashtable)mergedProperties).putAll(projectProperties);
        if (this.mappings != null) {
            for (int mappingNumber = 0; mappingNumber < this.mappings.length; ++mappingNumber) {
                this.processMapping(this.mappings[mappingNumber], mergedProperties, projectProperties);
            }
        }
    }

    protected void processMapping(PropertyMapping mapping, Properties input, Properties output) {
        PropertyDescription from = mapping.getFrom();
        PropertyDescription to = mapping.getTo();
        if (from == null || to == null) {
            return;
        }
        Pattern namePattern = Pattern.compile(from.getName());
        Iterator it = ((Hashtable)input).entrySet().iterator();
        while (it.hasNext()) {
            Pattern valuePattern;
            Matcher valueMatcher;
            Map.Entry entry = it.next();
            Matcher nameMatcher = namePattern.matcher(entry.getKey().toString());
            if (!nameMatcher.matches() || !(valueMatcher = (valuePattern = Pattern.compile(from.getName() + "(?:" + aMagicStringImpossibleToMatchAccidentally + ")" + from.getValue())).matcher(entry.getKey().toString() + aMagicStringImpossibleToMatchAccidentally + entry.getValue().toString())).matches()) continue;
            StringBuffer key = new StringBuffer();
            StringBuffer value = new StringBuffer();
            valueMatcher.appendReplacement(key, to.getName());
            valueMatcher.reset();
            valueMatcher.matches();
            valueMatcher.appendReplacement(value, to.getValue());
            ((Hashtable)output).put(key.toString(), value.toString());
        }
    }
}

