/*
 * Decompiled with CFR 0.152.
 */
package eu.rekawek.toxiproxy.model;

import com.google.gson.JsonObject;
import eu.rekawek.toxiproxy.HttpClient;
import eu.rekawek.toxiproxy.model.Toxic;
import eu.rekawek.toxiproxy.model.toxic.Bandwidth;
import eu.rekawek.toxiproxy.model.toxic.Latency;
import eu.rekawek.toxiproxy.model.toxic.LimitData;
import eu.rekawek.toxiproxy.model.toxic.ResetPeer;
import eu.rekawek.toxiproxy.model.toxic.Slicer;
import eu.rekawek.toxiproxy.model.toxic.SlowClose;
import eu.rekawek.toxiproxy.model.toxic.Timeout;

public enum ToxicType {
    LATENCY{

        @Override
        protected Toxic doCreateToxic(HttpClient httpClient, String path, JsonObject json) {
            return new Latency(httpClient, path, json);
        }
    }
    ,
    BANDWIDTH{

        @Override
        protected Toxic doCreateToxic(HttpClient httpClient, String path, JsonObject json) {
            return new Bandwidth(httpClient, path, json);
        }
    }
    ,
    SLOW_CLOSE{

        @Override
        protected Toxic doCreateToxic(HttpClient httpClient, String path, JsonObject json) {
            return new SlowClose(httpClient, path, json);
        }
    }
    ,
    TIMEOUT{

        @Override
        protected Toxic doCreateToxic(HttpClient httpClient, String path, JsonObject json) {
            return new Timeout(httpClient, path, json);
        }
    }
    ,
    SLICER{

        @Override
        protected Toxic doCreateToxic(HttpClient httpClient, String path, JsonObject json) {
            return new Slicer(httpClient, path, json);
        }
    }
    ,
    LIMIT_DATA{

        @Override
        protected Toxic doCreateToxic(HttpClient httpClient, String path, JsonObject json) {
            return new LimitData(httpClient, path, json);
        }
    }
    ,
    RESET_PEER{

        @Override
        protected Toxic doCreateToxic(HttpClient httpClient, String path, JsonObject json) {
            return new ResetPeer(httpClient, path, json);
        }
    };


    protected abstract Toxic doCreateToxic(HttpClient var1, String var2, JsonObject var3);

    public static Toxic createToxic(HttpClient httpClient, String path, JsonObject json) {
        String type = json.get("type").getAsString();
        return ToxicType.valueOf(type.toUpperCase()).doCreateToxic(httpClient, path, json);
    }
}

