/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.nisse.source.jgit;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VersionInformation {
    private static final String MAJOR_MINOR_PATCH_PATTERN = "^((\\d+)(\\.(\\d+)(\\.(\\d+))?)?)";
    private static final Pattern MAJOR_MINOR_PATCH = Pattern.compile("^((\\d+)(\\.(\\d+)(\\.(\\d+))?)?)");
    private static final Pattern DIGITS = Pattern.compile("^((\\d+)(\\.(\\d+)(\\.(\\d+))?)?)(.*)$");
    private static final Pattern BUILD_NUMBER = Pattern.compile("(((\\-)(\\d+)(.*))?)|(\\.(.*))|(\\-(.*))|(.*)$");
    private int major;
    private int minor;
    private int patch;
    private long buildNumber;
    private String qualifier;

    private void parseBuildNumber(String buildNumberPart) {
        Matcher matcher = BUILD_NUMBER.matcher(buildNumberPart);
        if (matcher.matches()) {
            String buildNumber = matcher.group(4);
            String qualifier = matcher.group(5);
            if (buildNumber != null) {
                this.setBuildNumber(Long.parseLong(buildNumber));
            }
            if (matcher.group(7) != null) {
                qualifier = matcher.group(7);
            }
            if (matcher.group(9) != null) {
                qualifier = matcher.group(9);
            }
            if (qualifier != null) {
                if (qualifier.trim().isEmpty()) {
                    this.setQualifier(null);
                } else {
                    this.setQualifier(qualifier);
                }
            } else {
                this.setQualifier(null);
            }
        }
    }

    private void parseMajorMinorPatchVersion(String version) {
        Matcher matcher = MAJOR_MINOR_PATCH.matcher(version);
        if (matcher.matches()) {
            String majorString = matcher.group(2);
            String minorString = matcher.group(4);
            String patchString = matcher.group(6);
            if (majorString != null) {
                this.setMajor(Integer.parseInt(majorString));
            }
            if (minorString != null) {
                this.setMinor(Integer.parseInt(minorString));
            }
            if (patchString != null) {
                this.setPatch(Integer.parseInt(patchString));
            }
        }
    }

    public VersionInformation(String version) {
        Matcher matcherDigits = DIGITS.matcher(version);
        if (matcherDigits.matches()) {
            this.parseMajorMinorPatchVersion(matcherDigits.group(1));
            this.parseBuildNumber(matcherDigits.group(7));
        } else {
            this.setQualifier(version);
        }
    }

    public int getMajor() {
        return this.major;
    }

    public void setMajor(int major) {
        this.major = major;
    }

    public int getMinor() {
        return this.minor;
    }

    public void setMinor(int minor) {
        this.minor = minor;
    }

    public int getPatch() {
        return this.patch;
    }

    public void setPatch(int patch) {
        this.patch = patch;
    }

    public long getBuildNumber() {
        return this.buildNumber;
    }

    public void setBuildNumber(long buildNumber) {
        this.buildNumber = buildNumber;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public void setQualifier(String qualifier) {
        this.qualifier = qualifier;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getMajor());
        sb.append(".").append(this.getMinor());
        sb.append(".").append(this.getPatch());
        if (this.getQualifier() != null || this.getBuildNumber() != 0L) {
            if (this.getBuildNumber() != 0L) {
                sb.append("-");
                sb.append(this.getBuildNumber());
            }
            if (this.getQualifier() != null) {
                sb.append("-");
                sb.append(this.getQualifier());
            }
        }
        return sb.toString();
    }
}

