/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.nisse.source.file;

import eu.maveniverse.maven.nisse.core.NisseConfiguration;
import eu.maveniverse.maven.nisse.core.PropertySource;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.inject.Named;
import javax.inject.Singleton;

@Singleton
@Named(value="file")
public class PropertyFilePropertySource
implements PropertySource {
    public static final String NAME = "file";
    public static final String FILE_NAME = "nisse.source.file.name";

    public String getName() {
        return NAME;
    }

    public Map<String, String> getProperties(NisseConfiguration configuration) {
        Path propertyFilePath;
        String propertyFile = (String)configuration.getConfiguration().get(FILE_NAME);
        HashMap<String, String> properties = new HashMap<String, String>();
        if (propertyFile != null && Files.isRegularFile(propertyFilePath = configuration.getCurrentWorkingDirectory().resolve(propertyFile), new LinkOption[0])) {
            try (InputStream stream = Files.newInputStream(propertyFilePath, new OpenOption[0]);){
                Properties prop = new Properties();
                prop.load(stream);
                for (String key : prop.stringPropertyNames()) {
                    properties.put(key, prop.getProperty(key));
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return Collections.unmodifiableMap(properties);
    }
}

