/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.nisse.extension3.internal;

import eu.maveniverse.maven.nisse.extension3.internal.NissePropertyInliner;
import java.util.Objects;
import java.util.Properties;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.interpolation.ModelVersionProcessor;
import org.eclipse.sisu.Priority;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Named
@Priority(value=200)
final class NisseModelVersionProcessor
implements ModelVersionProcessor {
    private final Logger logger = LoggerFactory.getLogger(NisseModelVersionProcessor.class);
    private final Provider<MavenSession> sessionProvider;
    private final NissePropertyInliner inliner;

    @Inject
    public NisseModelVersionProcessor(Provider<MavenSession> sessionProvider, NissePropertyInliner inliner) {
        this.sessionProvider = Objects.requireNonNull(sessionProvider, "sessionProvider");
        this.inliner = Objects.requireNonNull(inliner, "inliner");
    }

    public boolean isValidProperty(String property) {
        boolean valid;
        MavenSession session = (MavenSession)this.sessionProvider.get();
        boolean bl = valid = property.startsWith("nisse.") && session.getRequest().getUserProperties().containsKey(property);
        if (valid) {
            this.inliner.inlinedKeys(session).add(property);
        }
        return valid;
    }

    public void overwriteModelProperties(Properties modelProperties, ModelBuildingRequest request) {
        try {
            MavenSession session = (MavenSession)this.sessionProvider.get();
            for (String inlinedKey : this.inliner.inlinedKeys(session)) {
                modelProperties.setProperty(inlinedKey, session.getRequest().getUserProperties().getProperty(inlinedKey));
            }
        }
        catch (Exception e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.warn("NisseModelVersionProcessor.overwriteModelProperties: failed, called out of session?", (Throwable)e);
            }
            this.logger.warn("NisseModelVersionProcessor.overwriteModelProperties: failed, called out of session?");
        }
    }
}

