/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.nisse.extension3.internal;

import eu.maveniverse.maven.nisse.core.NisseConfiguration;
import eu.maveniverse.maven.nisse.core.NisseManager;
import eu.maveniverse.maven.nisse.core.Version;
import eu.maveniverse.maven.nisse.core.internal.SimpleNisseConfiguration;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.cli.CliRequest;
import org.apache.maven.cli.configuration.ConfigurationProcessor;
import org.apache.maven.cli.configuration.SettingsXmlConfigurationProcessor;
import org.eclipse.sisu.Priority;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Named
@Priority(value=200)
final class NisseConfigurationProcessor
implements ConfigurationProcessor {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final NisseManager nisseManager;
    private final SettingsXmlConfigurationProcessor settingsXmlConfigurationProcessor;

    @Inject
    public NisseConfigurationProcessor(NisseManager nisseManager, SettingsXmlConfigurationProcessor settingsXmlConfigurationProcessor) {
        this.nisseManager = Objects.requireNonNull(nisseManager, "nisseManager");
        this.settingsXmlConfigurationProcessor = Objects.requireNonNull(settingsXmlConfigurationProcessor, "settingsXmlConfigurationProcessor");
    }

    public void process(CliRequest request) throws Exception {
        this.settingsXmlConfigurationProcessor.process(request);
        this.logger.info("Maveniverse Nisse {} loaded", (Object)Version.version());
        Properties userProperties = request.getUserProperties();
        SimpleNisseConfiguration configuration = SimpleNisseConfiguration.builder().withSystemProperties(request.getSystemProperties()).withUserProperties(request.getUserProperties()).withCurrentWorkingDirectory(Paths.get(request.getWorkingDirectory(), new String[0])).withSessionRootDirectory(request.getMultiModuleProjectDirectory().toPath()).build();
        Map nisseProperties = this.nisseManager.createProperties((NisseConfiguration)configuration);
        this.logger.info("Nisse injecting {} properties into User Properties", (Object)nisseProperties.size());
        if (Boolean.parseBoolean(request.getUserProperties().getProperty("nisse.dump", "false"))) {
            nisseProperties.forEach((k, v) -> this.logger.info("{}={}", k, v));
        }
        nisseProperties.forEach((k, v) -> {
            if (!userProperties.containsKey(k)) {
                request.getUserProperties().setProperty((String)k, (String)v);
            }
        });
    }
}

