/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util.featuregen;

import java.util.ArrayList;
import java.util.Collection;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.featuregen.FeatureGenerator;

public class WordNGramFeatureGenerator
implements FeatureGenerator {
    public static final WordNGramFeatureGenerator INSTANCE = new WordNGramFeatureGenerator();
    private int minGram = 2;
    private int maxGram = 2;

    public WordNGramFeatureGenerator(int minGram, int maxGram) throws InvalidFormatException {
        if (minGram > 0 && maxGram > 0) {
            if (minGram > maxGram) {
                throw new InvalidFormatException("Minimum range value (minGram) should be less than or equal to maximum range value (maxGram)!");
            }
        } else {
            throw new InvalidFormatException("Both minimum range value (minGram) & maximum range value (maxGram) should be greater than or equal to 1!");
        }
        this.minGram = minGram;
        this.maxGram = maxGram;
    }

    public WordNGramFeatureGenerator() {
    }

    @Override
    public Collection<String> extractFeatures(String[] text) {
        ArrayList<String> features = new ArrayList<String>();
        for (int i = 0; i <= text.length - this.minGram; ++i) {
            String feature = "ng=" + text[i];
            for (int y = 1; y < this.maxGram && i + y < text.length; ++y) {
                feature = feature + ":" + text[i + y];
                int gramCount = y + 1;
                if (this.maxGram < gramCount || gramCount < this.minGram) continue;
                features.add(feature);
            }
        }
        return features;
    }
}

