/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util.featuregen;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import opennlp.tools.util.featuregen.FeatureGenerator;
import org.apache.commons.io.FileUtils;

public class BagOfWordsFeatureGenerator
implements FeatureGenerator {
    public static final BagOfWordsFeatureGenerator INSTANCE = new BagOfWordsFeatureGenerator();
    private static List<String> stopwords = new ArrayList<String>();

    @Override
    public Collection<String> extractFeatures(String[] text) {
        ArrayList<String> bagOfWords = new ArrayList<String>();
        for (String word : text) {
            if (stopwords.contains(word)) continue;
            bagOfWords.add("bow=" + word);
        }
        return bagOfWords;
    }

    static {
        try {
            stopwords = FileUtils.readLines((File)new File("props/stopwords.txt"), (String)"utf-8");
        }
        catch (IOException e) {
            stopwords = new ArrayList<String>();
        }
    }
}

