/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.tokenize;

import java.util.ArrayList;
import opennlp.tools.stemmer.PorterStemmer;
import opennlp.tools.tokenize.Tokenizer;
import opennlp.tools.util.Span;
import opennlp.tools.util.StringUtil;

public class StemmerTokenizer
implements Tokenizer {
    public static final StemmerTokenizer INSTANCE = new StemmerTokenizer();
    private PorterStemmer stemmer = new PorterStemmer();

    private StemmerTokenizer() {
    }

    public String[] tokenize(String s) {
        ArrayList<String> tokens = new ArrayList<String>();
        boolean inTok = false;
        StringBuilder curr = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            if (StringUtil.isWhitespace((char)s.charAt(i))) {
                if (!inTok) continue;
                this.stemmer.stem();
                String tok = this.stemmer.toString();
                this.stemmer.reset();
                tokens.add(tok);
                inTok = false;
                continue;
            }
            this.stemmer.add(s.charAt(i));
            inTok = true;
        }
        if (inTok) {
            this.stemmer.stem();
            tokens.add(this.stemmer.toString());
        }
        return tokens.toArray(new String[tokens.size()]);
    }

    public Span[] tokenizePos(String s) {
        return new Span[0];
    }
}

