/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ml.model;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import opennlp.tools.ml.model.AbstractDataIndexer;
import opennlp.tools.ml.model.ComparableEvent;
import opennlp.tools.ml.model.Event;
import opennlp.tools.ml.model.FileEventStream;
import opennlp.tools.ml.model.PredicateStatsObject;
import opennlp.tools.util.ObjectStream;

public class ChiSquaredDataIndexer
extends AbstractDataIndexer {
    public ChiSquaredDataIndexer(ObjectStream<Event> eventStream) throws IOException {
        this(eventStream, 0);
    }

    public ChiSquaredDataIndexer(ObjectStream<Event> eventStream, int cutoff) throws IOException {
        this(eventStream, cutoff, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChiSquaredDataIndexer(ObjectStream<Event> eventStream, int cutoff, boolean sort) throws IOException {
        HashMap<String, Integer> predicateIndex = new HashMap<String, Integer>();
        System.out.println("Indexing events using cutoff of " + cutoff + "\n");
        System.out.print("\tComputing event counts...  ");
        try {
            List<ComparableEvent> eventsToCompare;
            File tmp = File.createTempFile("events", null);
            tmp.deleteOnExit();
            BufferedWriter osw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(tmp), "UTF8"));
            int numEvents = this.computePredicateStats(eventStream, osw, predicateIndex, cutoff);
            System.out.println("done. " + numEvents + " events");
            System.out.print("\tIndexing...  ");
            try (FileEventStream fes = new FileEventStream(tmp);){
                eventsToCompare = this.index(numEvents, (ObjectStream<Event>)fes, predicateIndex);
            }
            predicateIndex = null;
            tmp.delete();
            System.out.println("done.");
            if (sort) {
                System.out.print("Sorting and merging events... ");
            } else {
                System.out.print("Collecting events... ");
            }
            this.sortAndMerge(eventsToCompare, sort);
            System.out.println("Done indexing.");
        }
        catch (IOException e) {
            System.err.println(e);
        }
    }

    private static double chisquare(String s, PredicateStatsObject stats) {
        Map<String, Integer> featureCounts = stats.predicateCategoryCounts.get(s);
        double maxScore = 0.0;
        int N1 = 0;
        for (Integer n : featureCounts.values()) {
            N1 += n.intValue();
        }
        int N0 = stats.eventCount - N1;
        for (Map.Entry entry : featureCounts.entrySet()) {
            double denominator;
            int N10;
            int N01;
            int N00;
            String category = (String)entry.getKey();
            int N11 = (Integer)entry.getValue();
            double numerator = stats.eventCount * (N11 * (N00 = N0 - (N01 = stats.categoryCounts.get(category) - N11)) - (N10 = N1 - N11) * N01) * (N11 * N00 - N10 * N01);
            double score = numerator / (denominator = (double)((N11 + N01) * (N11 + N10) * (N10 + N00) * (N01 + N00)));
            if (!(score > maxScore)) continue;
            maxScore = score;
        }
        return maxScore;
    }

    private int computePredicateStats(ObjectStream<Event> eventStream, Writer eventStore, Map<String, Integer> predicatesInOut, int cutoff) throws IOException {
        Event ev;
        HashSet predicateSet = new HashSet();
        HashMap counter = new HashMap();
        PredicateStatsObject stats = new PredicateStatsObject();
        while ((ev = (Event)eventStream.read()) != null) {
            eventStore.write(FileEventStream.toLine((Event)ev));
            ++stats.eventCount;
            String category = ev.getOutcome();
            Integer categoryCount = stats.categoryCounts.get(category);
            if (categoryCount == null) {
                stats.categoryCounts.put(category, 1);
            } else {
                categoryCount = categoryCount + 1;
                stats.categoryCounts.put(category, categoryCount);
            }
            String[] context = ev.getContext();
            ChiSquaredDataIndexer.update((String[])context, predicateSet, counter, (int)cutoff);
            Integer predicateCategoryCount = null;
            for (String s : context) {
                Map<String, Integer> predicateCounts = stats.predicateCategoryCounts.get(s);
                if (predicateCounts == null) {
                    stats.predicateCategoryCounts.put(s, new HashMap());
                } else {
                    predicateCategoryCount = predicateCounts.get(category);
                }
                if (predicateCategoryCount == null) {
                    predicateCategoryCount = 0;
                }
                predicateCategoryCount = predicateCategoryCount + 1;
                stats.predicateCategoryCounts.get(s).put(category, predicateCategoryCount);
            }
        }
        this.predCounts = new int[predicateSet.size()];
        int index = 0;
        for (String predicate : predicateSet) {
            if (!(ChiSquaredDataIndexer.chisquare(predicate, stats) > 2.71)) continue;
            this.predCounts[index] = (Integer)counter.get(predicate);
            predicatesInOut.put(predicate, index);
            ++index;
        }
        eventStore.close();
        return stats.eventCount;
    }

    private List<ComparableEvent> index(int numEvents, ObjectStream<Event> es, Map<String, Integer> predicateIndex) throws IOException {
        Event ev;
        HashMap<String, Integer> omap = new HashMap<String, Integer>();
        int outcomeCount = 0;
        ArrayList<ComparableEvent> eventsToCompare = new ArrayList<ComparableEvent>(numEvents);
        ArrayList<Integer> indexedContext = new ArrayList<Integer>();
        while ((ev = (Event)es.read()) != null) {
            int ocID;
            String[] econtext = ev.getContext();
            String oc = ev.getOutcome();
            if (omap.containsKey(oc)) {
                ocID = (Integer)omap.get(oc);
            } else {
                ocID = outcomeCount++;
                omap.put(oc, ocID);
            }
            for (String pred : econtext) {
                if (!predicateIndex.containsKey(pred)) continue;
                indexedContext.add(predicateIndex.get(pred));
            }
            if (indexedContext.size() > 0) {
                int[] cons = new int[indexedContext.size()];
                for (int ci = 0; ci < cons.length; ++ci) {
                    cons[ci] = (Integer)indexedContext.get(ci);
                }
                ComparableEvent ce = new ComparableEvent(ocID, cons);
                eventsToCompare.add(ce);
            } else {
                System.err.println("Dropped event " + ev.getOutcome() + ":" + Arrays.asList(ev.getContext()));
            }
            indexedContext.clear();
        }
        this.outcomeLabels = ChiSquaredDataIndexer.toIndexedStringArray(omap);
        this.predLabels = ChiSquaredDataIndexer.toIndexedStringArray(predicateIndex);
        return eventsToCompare;
    }
}

