/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ml.authorage;

import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import opennlp.tools.ml.EventModelSequenceTrainer;
import opennlp.tools.ml.EventTrainer;
import opennlp.tools.ml.SequenceTrainer;
import opennlp.tools.ml.maxent.AgeClassifyGIS;
import opennlp.tools.ml.maxent.GIS;
import opennlp.tools.util.ext.ExtensionLoader;
import opennlp.tools.util.ext.ExtensionNotLoadedException;

public class AgeClassifyTrainerFactory {
    private static final Map<String, Class> BUILTIN_TRAINERS;

    public static TrainerType getTrainerType(Map<String, String> trainParams) {
        String alogrithmValue = trainParams.get("Algorithm");
        if (alogrithmValue == null) {
            return TrainerType.EVENT_MODEL_TRAINER;
        }
        Class trainerClass = BUILTIN_TRAINERS.get(alogrithmValue);
        if (trainerClass != null) {
            if (EventTrainer.class.isAssignableFrom(trainerClass)) {
                return TrainerType.EVENT_MODEL_TRAINER;
            }
            if (EventModelSequenceTrainer.class.isAssignableFrom(trainerClass)) {
                return TrainerType.EVENT_MODEL_SEQUENCE_TRAINER;
            }
            if (SequenceTrainer.class.isAssignableFrom(trainerClass)) {
                return TrainerType.SEQUENCE_TRAINER;
            }
        }
        try {
            ExtensionLoader.instantiateExtension(EventTrainer.class, (String)alogrithmValue);
            return TrainerType.EVENT_MODEL_TRAINER;
        }
        catch (ExtensionNotLoadedException extensionNotLoadedException) {
            try {
                ExtensionLoader.instantiateExtension(EventModelSequenceTrainer.class, (String)alogrithmValue);
                return TrainerType.EVENT_MODEL_SEQUENCE_TRAINER;
            }
            catch (ExtensionNotLoadedException extensionNotLoadedException2) {
                try {
                    ExtensionLoader.instantiateExtension(SequenceTrainer.class, (String)alogrithmValue);
                    return TrainerType.SEQUENCE_TRAINER;
                }
                catch (ExtensionNotLoadedException extensionNotLoadedException3) {
                    return null;
                }
            }
        }
    }

    public static EventTrainer getEventTrainer(Map<String, String> trainParams, Map<String, String> reportMap) {
        String trainerType = trainParams.get("Algorithm");
        if (trainerType == null) {
            AgeClassifyGIS trainer = new AgeClassifyGIS();
            trainer.init(trainParams, reportMap);
            return trainer;
        }
        if (BUILTIN_TRAINERS.containsKey(trainerType)) {
            EventTrainer trainer = (EventTrainer)AgeClassifyTrainerFactory.createBuiltinTrainer(BUILTIN_TRAINERS.get(trainerType));
            trainer.init(trainParams, reportMap);
            return trainer;
        }
        EventTrainer trainer = (EventTrainer)ExtensionLoader.instantiateExtension(EventTrainer.class, (String)trainerType);
        trainer.init(trainParams, reportMap);
        return trainer;
    }

    public static boolean isValid(Map<String, String> trainParams) {
        String algorithmName = trainParams.get("Algorithm");
        if (algorithmName != null && !BUILTIN_TRAINERS.containsKey(algorithmName) && AgeClassifyTrainerFactory.getTrainerType(trainParams) == null) {
            return false;
        }
        try {
            String iterationsString;
            String cutoffString = trainParams.get("Cutoff");
            if (cutoffString != null) {
                Integer.parseInt(cutoffString);
            }
            if ((iterationsString = trainParams.get("Iterations")) != null) {
                Integer.parseInt(iterationsString);
            }
        }
        catch (NumberFormatException e) {
            return false;
        }
        String dataIndexer = trainParams.get("DataIndexer");
        return dataIndexer == null || "OnePass".equals(dataIndexer) || "TwoPass".equals(dataIndexer) || "ChiSquared".equals(dataIndexer);
    }

    private static <T> T createBuiltinTrainer(Class<T> trainerClass) {
        T theTrainer = null;
        if (trainerClass != null) {
            try {
                Constructor<T> contructor = trainerClass.getConstructor(new Class[0]);
                theTrainer = contructor.newInstance(new Object[0]);
            }
            catch (Exception e) {
                String msg = "Could not instantiate the " + trainerClass.getCanonicalName() + ". The initialization throw an exception.";
                System.err.println(msg);
                e.printStackTrace();
                throw new IllegalArgumentException(msg, e);
            }
        }
        return theTrainer;
    }

    static {
        HashMap<String, Class> _trainers = new HashMap<String, Class>();
        _trainers.put("AUTHORAGE", AgeClassifyGIS.class);
        _trainers.put("MAXENT", GIS.class);
        BUILTIN_TRAINERS = Collections.unmodifiableMap(_trainers);
    }

    public static enum TrainerType {
        EVENT_MODEL_TRAINER,
        EVENT_MODEL_SEQUENCE_TRAINER,
        SEQUENCE_TRAINER;

    }
}

