/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.authorage;

import java.io.File;
import java.io.IOException;
import opennlp.tools.authorage.AuthorAgeSample;
import opennlp.tools.authorage.AuthorAgeSampleStream;
import opennlp.tools.cmdline.ArgumentParser;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.ObjectStreamFactory;
import opennlp.tools.cmdline.StreamFactoryRegistry;
import opennlp.tools.cmdline.params.BasicFormatParams;
import opennlp.tools.formats.AbstractSampleStreamFactory;
import opennlp.tools.tokenize.Tokenizer;
import opennlp.tools.tokenize.WhitespaceTokenizer;
import opennlp.tools.util.InputStreamFactory;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.PlainTextByLineStream;
import opennlp.tools.util.ext.ExtensionLoader;

public class AuthorAgeSampleStreamFactory
extends AbstractSampleStreamFactory<AuthorAgeSample> {
    protected <P> AuthorAgeSampleStreamFactory(Class<P> params) {
        super(params);
    }

    private Tokenizer getTokenizer(String tokenizer) {
        if (tokenizer != null) {
            return (Tokenizer)ExtensionLoader.instantiateExtension(Tokenizer.class, (String)tokenizer);
        }
        return WhitespaceTokenizer.INSTANCE;
    }

    public ObjectStream<AuthorAgeSample> create(String[] args) {
        AuthorAgeStreamFactoryParams params = (AuthorAgeStreamFactoryParams)ArgumentParser.parse((String[])args, AuthorAgeStreamFactoryParams.class);
        CmdLineUtil.checkInputFile((String)"Data", (File)params.getData());
        InputStreamFactory sampleDataIn = CmdLineUtil.createInputStreamFactory((File)params.getData());
        PlainTextByLineStream lineStream = null;
        try {
            lineStream = new PlainTextByLineStream(sampleDataIn, params.getEncoding());
        }
        catch (IOException ex) {
            CmdLineUtil.handleCreateObjectStreamError((IOException)ex);
        }
        Tokenizer tokenizer = this.getTokenizer(params.getTokenizer());
        return new AuthorAgeSampleStream((ObjectStream<String>)lineStream, tokenizer);
    }

    public static void registerFactory() {
        StreamFactoryRegistry.registerFactory(AuthorAgeSample.class, (String)"authorage", (ObjectStreamFactory)new AuthorAgeSampleStreamFactory(AuthorAgeStreamFactoryParams.class));
    }

    static interface AuthorAgeStreamFactoryParams
    extends BasicFormatParams {
        @ArgumentParser.ParameterDescription(valueName="tokenizer", description="Tokenizer implementation. WhitespaceTokenizer is used if not specified.")
        @ArgumentParser.OptionalParameter
        public String getTokenizer();
    }
}

