/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.authorage;

import java.io.IOException;
import java.util.HashSet;
import opennlp.tools.authorage.AuthorAgeSample;
import opennlp.tools.tokenize.Tokenizer;
import opennlp.tools.tokenize.WhitespaceTokenizer;
import opennlp.tools.util.FilterObjectStream;
import opennlp.tools.util.ObjectStream;

public class AuthorAgeSampleStream
extends FilterObjectStream<String, AuthorAgeSample> {
    private Tokenizer tokenizer;

    public AuthorAgeSampleStream(ObjectStream<String> samples) {
        super(samples);
        this.tokenizer = WhitespaceTokenizer.INSTANCE;
    }

    public AuthorAgeSampleStream(ObjectStream<String> samples, Tokenizer tokenizer) {
        super(samples);
        this.tokenizer = tokenizer;
    }

    public AuthorAgeSample read() throws IOException {
        String sampleString = (String)this.samples.read();
        while (sampleString != null) {
            AuthorAgeSample sample;
            block8: {
                String text;
                String category;
                try {
                    category = sampleString.split("\t", 2)[0];
                    text = sampleString.split("\t", 2)[1];
                }
                catch (Exception e) {
                    sampleString = (String)this.samples.read();
                    continue;
                }
                String[] tokens = this.tokenizer.tokenize(text);
                if (tokens.length > 0) {
                    try {
                        int age = Integer.valueOf(category);
                        sample = new AuthorAgeSample(age, tokens);
                        break block8;
                    }
                    catch (NumberFormatException e) {
                        HashSet<String> categories = new HashSet<String>(){
                            {
                                this.add("xx-18");
                                this.add("25-34");
                                this.add("35-49");
                                this.add("50-64");
                                this.add("65-xx");
                            }
                        };
                        if (!categories.contains(category)) {
                            sampleString = (String)this.samples.read();
                            continue;
                        }
                        sample = new AuthorAgeSample(category, tokens);
                        break block8;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        sampleString = (String)this.samples.read();
                        continue;
                    }
                }
                sampleString = (String)this.samples.read();
                continue;
            }
            return sample;
        }
        return null;
    }
}

