/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.authorage;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class AuthorAgeSample
implements Serializable {
    private static final long serialVersionUID = 5374409234122582256L;
    public static final String FORMAT_NAME = "authorage";
    private final String ageCategory;
    private final List<String> text;

    public AuthorAgeSample(String category, String[] text) {
        if (category == null) {
            throw new IllegalArgumentException("Age cannot be null");
        }
        if (text == null) {
            throw new IllegalArgumentException("Text cannot be null");
        }
        this.ageCategory = category;
        this.text = Collections.unmodifiableList(new ArrayList<String>(Arrays.asList(text)));
    }

    public AuthorAgeSample(Integer age, String[] text) {
        if (age == null) {
            throw new IllegalArgumentException("Age cannot be null");
        }
        if (text == null) {
            throw new IllegalArgumentException("Text cannot be null");
        }
        this.ageCategory = age < 18 ? "xx-18" : (age >= 18 && age <= 24 ? "18-24" : (age >= 25 && age <= 34 ? "25-34" : (age >= 35 && age <= 49 ? "35-49" : (age >= 50 && age <= 64 ? "50-64" : "65-xx"))));
        this.text = Collections.unmodifiableList(new ArrayList<String>(Arrays.asList(text)));
    }

    public String getCategory() {
        return this.ageCategory;
    }

    public String[] getText() {
        return this.text.toArray(new String[this.text.size()]);
    }

    public String toString() {
        StringBuilder sampleString = new StringBuilder();
        sampleString.append(this.ageCategory).append('\t');
        for (String s : this.text) {
            sampleString.append(s).append(' ');
        }
        if (sampleString.length() > 0) {
            sampleString.setLength(sampleString.length() - 1);
        }
        return sampleString.toString();
    }
}

