/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.authorage;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import opennlp.tools.authorage.AgeClassifyContextGenerator;
import opennlp.tools.authorage.AgeClassifyEventStream;
import opennlp.tools.authorage.AgeClassifyFactory;
import opennlp.tools.authorage.AgeClassifyModel;
import opennlp.tools.authorage.AuthorAgeSample;
import opennlp.tools.ml.EventTrainer;
import opennlp.tools.ml.authorage.AgeClassifyTrainerFactory;
import opennlp.tools.ml.model.MaxentModel;
import opennlp.tools.tokenize.Tokenizer;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.TrainingParameters;

public class AgeClassifyME {
    protected AgeClassifyContextGenerator contextGenerator;
    private AgeClassifyFactory factory;
    private AgeClassifyModel model;

    public AgeClassifyME(AgeClassifyModel ageModel) {
        this.model = ageModel;
        this.factory = ageModel.getFactory();
        this.contextGenerator = new AgeClassifyContextGenerator(this.factory.getFeatureGenerators());
    }

    public String getBestCategory(double[] outcome) {
        return this.model.getMaxentModel().getBestOutcome(outcome);
    }

    public int getNumCategories() {
        return this.model.getMaxentModel().getNumOutcomes();
    }

    public String getCategory(int index) {
        return this.model.getMaxentModel().getOutcome(index);
    }

    public int getIndex(String category) {
        return this.model.getMaxentModel().getIndex(category);
    }

    public double[] getProbabilities(String[] text) {
        return this.model.getMaxentModel().eval(this.contextGenerator.getContext(text));
    }

    public double[] getProbabilities(String documentText) {
        Tokenizer tokenizer = this.factory.getTokenizer();
        return this.getProbabilities(tokenizer.tokenize(documentText));
    }

    public String predict(String documentText) {
        double[] probs = this.getProbabilities(documentText);
        String category = this.getBestCategory(probs);
        return category;
    }

    public Map<String, Double> scoreMap(String documentText) {
        HashMap<String, Double> probs = new HashMap<String, Double>();
        double[] categories = this.getProbabilities(documentText);
        int numCategories = this.getNumCategories();
        for (int i = 0; i < numCategories; ++i) {
            String category = this.getCategory(i);
            probs.put(category, categories[this.getIndex(category)]);
        }
        return probs;
    }

    public SortedMap<Double, Set<String>> sortedScoreMap(String documentText) {
        TreeMap<Double, Set<String>> sortedMap = new TreeMap<Double, Set<String>>();
        double[] categories = this.getProbabilities(documentText);
        int numCategories = this.getNumCategories();
        for (int i = 0; i < numCategories; ++i) {
            String category = this.getCategory(i);
            double score = categories[this.getIndex(category)];
            if (sortedMap.containsKey(score)) {
                ((Set)sortedMap.get(score)).add(category);
                continue;
            }
            HashSet<String> newset = new HashSet<String>();
            newset.add(category);
            sortedMap.put(score, newset);
        }
        return sortedMap;
    }

    public static AgeClassifyModel train(String languageCode, ObjectStream<AuthorAgeSample> samples, TrainingParameters trainParams, AgeClassifyFactory factory) throws IOException {
        HashMap<String, String> entries = new HashMap<String, String>();
        MaxentModel ageModel = null;
        AgeClassifyTrainerFactory.TrainerType trainerType = AgeClassifyTrainerFactory.getTrainerType(trainParams.getSettings());
        AgeClassifyEventStream eventStream = new AgeClassifyEventStream(samples, factory.createContextGenerator());
        EventTrainer trainer = AgeClassifyTrainerFactory.getEventTrainer(trainParams.getSettings(), entries);
        ageModel = trainer.train((ObjectStream)eventStream);
        HashMap<String, String> manifestInfoEntries = new HashMap<String, String>();
        return new AgeClassifyModel(languageCode, ageModel, manifestInfoEntries, factory);
    }
}

