/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.authorage;

import opennlp.tools.authorage.AgeClassifyContextGenerator;
import opennlp.tools.tokenize.Tokenizer;
import opennlp.tools.tokenize.WhitespaceTokenizer;
import opennlp.tools.util.BaseToolFactory;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.ext.ExtensionLoader;
import opennlp.tools.util.featuregen.BagOfWordsFeatureGenerator;
import opennlp.tools.util.featuregen.FeatureGenerator;

public class AgeClassifyFactory
extends BaseToolFactory {
    public static final AgeClassifyFactory INSTANCE = new AgeClassifyFactory();
    private static final String FEATURE_GENERATORS = "authorage.featureGenerators";
    private static final String TOKENIZER_NAME = "authorage.tokenizer";
    private FeatureGenerator[] featureGenerators;
    private Tokenizer tokenizer;

    public AgeClassifyFactory() {
    }

    protected void init(Tokenizer tokenizer, FeatureGenerator[] featureGenerators) {
        this.featureGenerators = featureGenerators;
        this.tokenizer = tokenizer;
    }

    public AgeClassifyFactory(Tokenizer tokenizer, FeatureGenerator[] featureGenerators) {
        this.init(tokenizer, featureGenerators);
    }

    public void validateArtifactMap() throws InvalidFormatException {
    }

    public static AgeClassifyFactory create(String subclassName, Tokenizer tokenizer, FeatureGenerator[] featureGenerators) throws InvalidFormatException {
        if (subclassName == null) {
            return new AgeClassifyFactory(tokenizer, featureGenerators);
        }
        try {
            AgeClassifyFactory factory = INSTANCE;
            factory.init(tokenizer, featureGenerators);
            return factory;
        }
        catch (Exception e) {
            String msg = "Could not instantiate the " + subclassName + ". The initialization throw an exception.";
            System.err.println(msg);
            e.printStackTrace();
            throw new InvalidFormatException(msg, (Throwable)e);
        }
    }

    private FeatureGenerator[] loadFeatureGenerators(String classNames) {
        String[] classes = classNames.split(",");
        FeatureGenerator[] features = new FeatureGenerator[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            features[i] = (FeatureGenerator)ExtensionLoader.instantiateExtension(FeatureGenerator.class, (String)classes[i]);
        }
        return features;
    }

    public FeatureGenerator[] getFeatureGenerators() {
        if (this.featureGenerators == null) {
            String classNames;
            if (this.artifactProvider != null && (classNames = this.artifactProvider.getManifestProperty(FEATURE_GENERATORS)) != null) {
                this.featureGenerators = this.loadFeatureGenerators(classNames);
            }
            if (this.featureGenerators == null) {
                FeatureGenerator[] def = new FeatureGenerator[]{BagOfWordsFeatureGenerator.INSTANCE};
                this.featureGenerators = def;
            }
        }
        return this.featureGenerators;
    }

    public void setFeatureGenerators(FeatureGenerator[] featureGenerators) {
        this.featureGenerators = featureGenerators;
    }

    public Tokenizer getTokenizer() {
        if (this.tokenizer == null) {
            String className;
            if (this.artifactProvider != null && (className = this.artifactProvider.getManifestProperty(TOKENIZER_NAME)) != null) {
                this.tokenizer = (Tokenizer)ExtensionLoader.instantiateExtension(Tokenizer.class, (String)className);
            }
            if (this.tokenizer == null) {
                this.tokenizer = WhitespaceTokenizer.INSTANCE;
            }
        }
        return this.tokenizer;
    }

    public void setTokenizer(Tokenizer tokenizer) {
        this.tokenizer = tokenizer;
    }

    public AgeClassifyContextGenerator createContextGenerator() {
        return new AgeClassifyContextGenerator(this.getFeatureGenerators());
    }
}

