/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.authorage;

import opennlp.tools.authorage.AgeClassifyEvaluationMonitor;
import opennlp.tools.authorage.AgeClassifyME;
import opennlp.tools.authorage.AuthorAgeSample;
import opennlp.tools.util.eval.EvaluationMonitor;
import opennlp.tools.util.eval.Evaluator;
import opennlp.tools.util.eval.Mean;

public class AgeClassifyEvaluator
extends Evaluator<AuthorAgeSample> {
    private AgeClassifyME classifier;
    private Mean accuracy = new Mean();

    public AgeClassifyEvaluator(AgeClassifyME classifier, AgeClassifyEvaluationMonitor ... listeners) {
        super((EvaluationMonitor[])listeners);
        this.classifier = classifier;
    }

    public AuthorAgeSample processSample(AuthorAgeSample sample) {
        String[] document = sample.getText();
        double[] probs = this.classifier.getProbabilities(document);
        String cat = this.classifier.getBestCategory(probs);
        if (sample.getCategory().equals(cat)) {
            this.accuracy.add(1.0);
        } else {
            this.accuracy.add(0.0);
        }
        return new AuthorAgeSample(cat, sample.getText());
    }

    public double getAccuracy() {
        return this.accuracy.mean();
    }

    public long getDocumentCount() {
        return this.accuracy.count();
    }

    public String toString() {
        return "Accuracy: " + this.accuracy.mean() + "\n" + "Number of documents: " + this.accuracy.count();
    }
}

