/*
 * Decompiled with CFR 0.152.
 */
package edu.usc.irds.agepredictor.spark.authorage;

import edu.usc.irds.agepredictor.spark.authorage.EventWrapper;
import java.util.Collection;
import java.util.Iterator;
import opennlp.tools.ml.model.Event;
import opennlp.tools.util.ObjectStream;
import org.apache.spark.api.java.JavaRDD;

public class EventStreamUtil {
    public static ObjectStream<Event> createEventStream(final Collection<EventWrapper> samples) {
        return new ObjectStream<Event>(){
            private Iterator<EventWrapper> iterator;
            {
                this.iterator = samples.iterator();
            }

            public Event read() {
                if (this.iterator.hasNext()) {
                    return this.iterator.next().getEvent();
                }
                return null;
            }

            public void reset() {
                this.iterator = samples.iterator();
            }

            public void close() {
            }
        };
    }

    public static ObjectStream<Event> createEventStream(final JavaRDD<EventWrapper> samples) {
        return new ObjectStream<Event>(){
            private Iterator<EventWrapper> iterator;
            {
                this.iterator = samples.toLocalIterator();
            }

            public Event read() {
                if (this.iterator.hasNext()) {
                    return this.iterator.next().getEvent();
                }
                return null;
            }

            public void reset() {
                this.iterator = samples.toLocalIterator();
            }

            public void close() {
            }
        };
    }
}

