/*
 * Decompiled with CFR 0.152.
 */
package edu.usc.irds.agepredictor.spark.authorage;

import edu.usc.irds.agepredictor.spark.authorage.AgeClassifyModelWrapper;
import java.io.File;
import java.io.IOException;
import java.util.List;
import opennlp.tools.authorage.AgeClassifyME;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.Function2;
import org.apache.spark.api.java.function.PairFunction;
import scala.Tuple2;

public class AgeClassifySparkEvaluator {
    public static void evaluate(File model, String dataIn) throws IOException {
        SparkConf conf = new SparkConf().setAppName("AgeClassifySparkEvaluator");
        JavaSparkContext sc = new JavaSparkContext(conf);
        JavaRDD data = sc.textFile(dataIn, 8).cache();
        JavaPairRDD samples = data.mapToPair((PairFunction)new PairFunction<String, String, String>(){

            public Tuple2<String, String> call(String s) {
                try {
                    String category = s.split("\t", 2)[0];
                    String text = s.split("\t", 2)[1];
                    return new Tuple2((Object)category, (Object)text);
                }
                catch (Exception e) {
                    return null;
                }
            }
        }).cache();
        JavaPairRDD validSamples = samples.filter((Function)new Function<Tuple2<String, String>, Boolean>(){

            public Boolean call(Tuple2<String, String> t) {
                return t != null;
            }
        }).cache();
        samples.unpersist();
        JavaPairRDD correct = validSamples.filter((Function)new EvaluateSample(model)).cache();
        long total = validSamples.count();
        long good = correct.count();
        if (total > 0L) {
            System.out.println("Accuracy: " + (double)good / (double)total);
            System.out.println("Number of Documents: " + total);
        }
        JavaPairRDD totalMap = validSamples.aggregateByKey((Object)0, (Function2)new Function2<Integer, String, Integer>(){

            public Integer call(Integer i, String s) {
                return i + 1;
            }
        }, (Function2)new Function2<Integer, Integer, Integer>(){

            public Integer call(Integer i1, Integer i2) {
                return i1 + i2;
            }
        }).cache();
        validSamples.unpersist();
        List totalCount = totalMap.collect();
        JavaPairRDD correctMap = correct.aggregateByKey((Object)0, (Function2)new Function2<Integer, String, Integer>(){

            public Integer call(Integer i, String s) {
                return i + 1;
            }
        }, (Function2)new Function2<Integer, Integer, Integer>(){

            public Integer call(Integer i1, Integer i2) {
                return i1 + i2;
            }
        }).cache();
        correct.unpersist();
        List correctCount = correctMap.collect();
        for (int i = 0; i < totalCount.size(); ++i) {
            if ((Integer)((Tuple2)totalCount.get(i))._2() <= 0) continue;
            System.out.println((String)((Tuple2)totalCount.get(i))._1() + ": " + ((Tuple2)totalCount.get(i))._2() + " documents");
            System.out.println("Accuracy: " + (double)((Integer)((Tuple2)correctCount.get(i))._2()).intValue() / (double)((Integer)((Tuple2)totalCount.get(i))._2()).intValue());
        }
        sc.stop();
    }

    public static class EvaluateSample
    implements Function<Tuple2<String, String>, Boolean> {
        private AgeClassifyModelWrapper wrapper;

        public EvaluateSample(File model) {
            this.wrapper = new AgeClassifyModelWrapper(model);
        }

        public EvaluateSample(AgeClassifyModelWrapper w) {
            this.wrapper = w;
        }

        public Boolean call(Tuple2<String, String> sample) throws IOException {
            String category = (String)sample._1();
            String text = (String)sample._2();
            System.out.println("Sample: " + category + ", " + text);
            AgeClassifyME classifier = this.wrapper.getClassifier();
            String predicted = classifier.predict(text);
            return predicted == category;
        }
    }
}

