/*
 * Decompiled with CFR 0.152.
 */
package edu.usc.irds.agepredictor.cmdline.spark.authorage;

import edu.usc.irds.agepredictor.cmdline.params.SparkTrainingToolParams;
import edu.usc.irds.agepredictor.spark.authorage.AgeClassifySparkTrainer;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import opennlp.tools.authorage.AgeClassifyModel;
import opennlp.tools.authorage.AuthorAgeSample;
import opennlp.tools.cmdline.AbstractTrainerTool;
import opennlp.tools.cmdline.ArgumentParser;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.ObjectStreamFactory;
import opennlp.tools.cmdline.StreamFactoryRegistry;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.ml.authorage.AgeClassifyTrainerFactory;
import opennlp.tools.util.TrainingParameters;
import opennlp.tools.util.model.BaseModel;
import opennlp.tools.util.model.ModelUtil;

public class AgeClassifySparkTrainerTool
extends AbstractTrainerTool<AuthorAgeSample, SparkTrainingToolParams> {
    protected SparkTrainingToolParams params;
    protected TrainingParameters mlParams;

    public AgeClassifySparkTrainerTool() {
        super(AuthorAgeSample.class, SparkTrainingToolParams.class);
    }

    public String getShortDescription() {
        return "trainer for the author age classifier, using Spark API";
    }

    public String getHelp(String format) {
        if ("".equals(format) || "opennlp".equals(format)) {
            return this.getBasicHelp(new Class[]{this.paramsClass, StreamFactoryRegistry.getFactory((Class)this.type, (String)"opennlp").getParameters()});
        }
        ObjectStreamFactory factory = StreamFactoryRegistry.getFactory((Class)this.type, (String)format);
        if (null == factory) {
            throw new TerminateToolException(1, "Format " + format + " is not found.\n" + this.getHelp());
        }
        return "Usage: bin/authorage " + this.getName() + " " + ArgumentParser.createUsage((Class[])new Class[]{this.paramsClass, factory.getParameters()});
    }

    public void run(String format, String[] args) {
        AgeClassifyModel model;
        this.validateAllArgs(args, this.paramsClass, format);
        this.params = (SparkTrainingToolParams)ArgumentParser.parse((String[])ArgumentParser.filter((String[])args, (Class)this.paramsClass), (Class)this.paramsClass);
        TrainingParameters mlParams = null;
        String paramFile = this.params.getParams();
        if (paramFile != null) {
            CmdLineUtil.checkInputFile((String)"Training Parameter", (File)new File(paramFile));
            InputStream paramsIn = null;
            try {
                paramsIn = new FileInputStream(new File(paramFile));
                mlParams = new TrainingParameters(paramsIn);
            }
            catch (IOException e) {
                throw new TerminateToolException(-1, "Error during parameters loading: " + e.getMessage(), (Throwable)e);
            }
            finally {
                try {
                    if (paramsIn != null) {
                        paramsIn.close();
                    }
                }
                catch (IOException iOException) {}
            }
            if (!AgeClassifyTrainerFactory.isValid((Map)mlParams.getSettings())) {
                throw new TerminateToolException(1, "Training parameters file '" + paramFile + "' is invalid!");
            }
        }
        if (mlParams == null) {
            mlParams = ModelUtil.createDefaultTrainingParameters();
        }
        File modelOutFile = this.params.getModel();
        CmdLineUtil.checkOutputFile((String)"age classifier model", (File)modelOutFile);
        System.out.println("Feature Generators: " + this.params.getFeatureGenerators());
        System.out.println("Tokenizer: " + this.params.getTokenizer());
        try {
            model = AgeClassifySparkTrainer.createModel(this.params.getLang(), this.params.getData(), this.params.getTokenizer(), this.params.getFeatureGenerators(), mlParams);
        }
        catch (IOException e) {
            throw new TerminateToolException(-1, "IO error while reading training data or indexing data: " + e.getMessage(), (Throwable)e);
        }
        CmdLineUtil.writeModel((String)"age classifier", (File)modelOutFile, (BaseModel)model);
    }
}

