/*
 * Decompiled with CFR 0.152.
 */
package edu.usc.irds.agepredictor.authorage.example;

import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import opennlp.tools.authorage.AgeClassifyFactory;
import opennlp.tools.authorage.AgeClassifyME;
import opennlp.tools.authorage.AgeClassifyModel;
import opennlp.tools.authorage.AuthorAgeSampleStream;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.PlainTextByLineStream;
import opennlp.tools.util.TrainingParameters;

public class AgeClassifyExample {
    AgeClassifyModel model;
    private final String INPUT_PATH = "/Users/joeyhong/eclipse-workspace/AgePrediction/data/blogs/blogs-test.txt";
    private final String MODEL_PATH = "/Users/joeyhong/eclipse-workspace/AgePrediction/model/blogs-test-model";

    public static void main(String[] args) throws IOException {
        AgeClassifyExample myClassifier = new AgeClassifyExample();
        myClassifier.train();
        myClassifier.classify("Hello World!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void train() {
        FileInputStream dataIn = null;
        AuthorAgeSampleStream sampleStream = null;
        try {
            dataIn = new FileInputStream("/Users/joeyhong/eclipse-workspace/AgePrediction/data/blogs/blogs-test.txt");
            PlainTextByLineStream lineStream = new PlainTextByLineStream((InputStream)dataIn, "UTF-8");
            sampleStream = new AuthorAgeSampleStream((ObjectStream)lineStream);
            TrainingParameters params = new TrainingParameters();
            params.put("Cutoff", Integer.toString(0));
            params.put("Iterations", Integer.toString(100));
            AgeClassifyFactory factory = new AgeClassifyFactory();
            this.model = AgeClassifyME.train((String)"en", (ObjectStream)sampleStream, (TrainingParameters)params, (AgeClassifyFactory)factory);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (dataIn != null) {
                try {
                    ((InputStream)dataIn).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void saveModel() {
        OutputStream modelOutput = null;
        try {
            modelOutput = new BufferedOutputStream(new FileOutputStream("/Users/joeyhong/eclipse-workspace/AgePrediction/model/blogs-test-model"));
            this.model.serialize(modelOutput);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (modelOutput != null) {
                try {
                    modelOutput.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void classify(String text) throws IOException {
        AgeClassifyME classifier = new AgeClassifyME(this.model);
        String predictedCategory = classifier.predict(text);
        System.out.println("Model prediction: " + predictedCategory);
    }
}

