/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.wavelet.synthesis;

import jj2000.j2k.decoder.DecoderSpecs;
import jj2000.j2k.image.Coord;
import jj2000.j2k.wavelet.synthesis.InvWT;
import jj2000.j2k.wavelet.synthesis.MultiResImgData;
import jj2000.j2k.wavelet.synthesis.SubbandSyn;

public abstract class InvWTAdapter
implements InvWT {
    protected DecoderSpecs decSpec;
    protected MultiResImgData mressrc;
    protected int reslvl;
    protected int maxImgRes;

    protected InvWTAdapter(MultiResImgData src, DecoderSpecs decSpec) {
        this.mressrc = src;
        this.decSpec = decSpec;
        this.maxImgRes = decSpec.dls.getMin();
    }

    @Override
    public void setImgResLevel(int rl) {
        if (rl < 0) {
            throw new IllegalArgumentException("Resolution level index cannot be negative.");
        }
        this.reslvl = rl;
    }

    @Override
    public int getTileWidth() {
        int tIdx = this.getTileIdx();
        int rl = 10000;
        int nc = this.mressrc.getNumComps();
        for (int c = 0; c < nc; ++c) {
            int mrl = this.mressrc.getSynSubbandTree((int)tIdx, (int)c).resLvl;
            if (mrl >= rl) continue;
            rl = mrl;
        }
        return this.mressrc.getTileWidth(rl);
    }

    @Override
    public int getTileHeight() {
        int tIdx = this.getTileIdx();
        int rl = 10000;
        int nc = this.mressrc.getNumComps();
        for (int c = 0; c < nc; ++c) {
            int mrl = this.mressrc.getSynSubbandTree((int)tIdx, (int)c).resLvl;
            if (mrl >= rl) continue;
            rl = mrl;
        }
        return this.mressrc.getTileHeight(rl);
    }

    @Override
    public int getNomTileWidth() {
        return this.mressrc.getNomTileWidth();
    }

    @Override
    public int getNomTileHeight() {
        return this.mressrc.getNomTileHeight();
    }

    @Override
    public int getImgWidth() {
        return this.mressrc.getImgWidth(this.reslvl);
    }

    @Override
    public int getImgHeight() {
        return this.mressrc.getImgHeight(this.reslvl);
    }

    @Override
    public int getNumComps() {
        return this.mressrc.getNumComps();
    }

    @Override
    public int getCompSubsX(int c) {
        return this.mressrc.getCompSubsX(c);
    }

    @Override
    public int getCompSubsY(int c) {
        return this.mressrc.getCompSubsY(c);
    }

    @Override
    public int getTileCompWidth(int t, int c) {
        int rl = this.mressrc.getSynSubbandTree((int)t, (int)c).resLvl;
        return this.mressrc.getTileCompWidth(t, c, rl);
    }

    @Override
    public int getTileCompHeight(int t, int c) {
        int rl = this.mressrc.getSynSubbandTree((int)t, (int)c).resLvl;
        return this.mressrc.getTileCompHeight(t, c, rl);
    }

    @Override
    public int getCompImgWidth(int c) {
        int rl = this.decSpec.dls.getMinInComp(c);
        return this.mressrc.getCompImgWidth(c, rl);
    }

    @Override
    public int getCompImgHeight(int c) {
        int rl = this.decSpec.dls.getMinInComp(c);
        return this.mressrc.getCompImgHeight(c, rl);
    }

    @Override
    public void setTile(int x, int y) {
        this.mressrc.setTile(x, y);
    }

    @Override
    public void nextTile() {
        this.mressrc.nextTile();
    }

    @Override
    public Coord getTile(Coord co) {
        return this.mressrc.getTile(co);
    }

    @Override
    public int getTileIdx() {
        return this.mressrc.getTileIdx();
    }

    @Override
    public int getCompULX(int c) {
        int tIdx = this.getTileIdx();
        int rl = this.mressrc.getSynSubbandTree((int)tIdx, (int)c).resLvl;
        return this.mressrc.getResULX(c, rl);
    }

    @Override
    public int getCompULY(int c) {
        int tIdx = this.getTileIdx();
        int rl = this.mressrc.getSynSubbandTree((int)tIdx, (int)c).resLvl;
        return this.mressrc.getResULY(c, rl);
    }

    @Override
    public int getImgULX() {
        return this.mressrc.getImgULX(this.reslvl);
    }

    @Override
    public int getImgULY() {
        return this.mressrc.getImgULY(this.reslvl);
    }

    @Override
    public int getTilePartULX() {
        return this.mressrc.getTilePartULX();
    }

    @Override
    public int getTilePartULY() {
        return this.mressrc.getTilePartULY();
    }

    @Override
    public Coord getNumTiles(Coord co) {
        return this.mressrc.getNumTiles(co);
    }

    @Override
    public int getNumTiles() {
        return this.mressrc.getNumTiles();
    }

    public SubbandSyn getSynSubbandTree(int t, int c) {
        return this.mressrc.getSynSubbandTree(t, c);
    }
}

