/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.collection;

import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.ExtensionRegistryLite;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import thredds.inventory.MFile;
import ucar.coord.Coordinate;
import ucar.coord.CoordinateEns;
import ucar.coord.CoordinateRuntime;
import ucar.coord.CoordinateTime;
import ucar.coord.CoordinateTime2D;
import ucar.coord.CoordinateTimeAbstract;
import ucar.coord.CoordinateTimeIntv;
import ucar.coord.CoordinateVert;
import ucar.coord.TwoDTimeInventory;
import ucar.nc2.constants.CDM;
import ucar.nc2.grib.EnsCoord;
import ucar.nc2.grib.GribTables;
import ucar.nc2.grib.TimeCoord;
import ucar.nc2.grib.VertCoord;
import ucar.nc2.grib.collection.GcMFile;
import ucar.nc2.grib.collection.GribCollection;
import ucar.nc2.grib.collection.GribCollectionProto;
import ucar.nc2.grib.collection.PartitionCollectionProto;
import ucar.nc2.stream.NcStream;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateUnit;
import ucar.nc2.time.CalendarPeriod;
import ucar.unidata.io.RandomAccessFile;

public abstract class GribCollectionBuilderFromIndex {
    protected final boolean dataOnly;
    protected GribCollection gc;
    protected final Logger logger;
    protected boolean debug = false;
    protected GribTables tables;

    protected abstract void readGds(GribCollectionProto.Gds var1);

    protected abstract GribTables makeCustomizer() throws IOException;

    protected abstract String getLevelNameShort(int var1);

    protected GribCollectionBuilderFromIndex(GribCollection gc, boolean dataOnly, Logger logger) {
        this.logger = logger;
        this.dataOnly = dataOnly;
        this.gc = gc;
    }

    protected abstract String getMagicStart();

    protected boolean readIndex(RandomAccessFile raf) throws IOException {
        this.gc.setIndexRaf(raf);
        try {
            int i;
            int size;
            boolean versionOk;
            raf.order(0);
            raf.seek(0L);
            if (!NcStream.readAndTest((RandomAccessFile)raf, (byte[])this.getMagicStart().getBytes(CDM.utf8Charset))) {
                raf.seek(0L);
                NcStream.readAndTest((RandomAccessFile)raf, (byte[])this.getMagicStart().getBytes(CDM.utf8Charset));
                this.logger.warn("GribCollectionBuilderFromIndex {}: invalid index raf={}", (Object)this.gc.getName(), (Object)raf.getLocation());
                throw new IllegalStateException();
            }
            this.gc.version = raf.readInt();
            boolean bl = versionOk = this.gc.version >= 1;
            if (!versionOk) {
                this.logger.warn("GribCollectionBuilderFromIndex {}: index found version={}, want version= {} on file {}", new Object[]{this.gc.getName(), this.gc.version, 1, raf.getLocation()});
                throw new IllegalStateException();
            }
            long skip = raf.readLong();
            raf.skipBytes(skip);
            if (this.debug) {
                System.out.printf("GribCollectionBuilderFromIndex %s (%s) records len = %d%n", raf.getLocation(), this.getMagicStart(), skip);
            }
            if ((size = NcStream.readVInt((RandomAccessFile)raf)) < 0 || size > 200000000) {
                this.logger.warn("GribCollectionBuilderFromIndex {}: invalid index size", (Object)this.gc.getName(), (Object)raf.getLocation());
                throw new IllegalStateException();
            }
            if (this.debug) {
                System.out.printf("GribCollectionBuilderFromIndex proto len = %d%n", size);
            }
            byte[] m = new byte[size];
            raf.readFully(m);
            ExtensionRegistry registry = ExtensionRegistry.newInstance();
            PartitionCollectionProto.registerAllExtensions(registry);
            GribCollectionProto.GribCollection proto = GribCollectionProto.GribCollection.parseFrom(m, (ExtensionRegistryLite)registry);
            this.gc.center = proto.getCenter();
            this.gc.subcenter = proto.getSubcenter();
            this.gc.master = proto.getMaster();
            this.gc.local = proto.getLocal();
            this.gc.genProcessType = proto.getGenProcessType();
            this.gc.genProcessId = proto.getGenProcessId();
            this.gc.backProcessId = proto.getBackProcessId();
            this.gc.local = proto.getLocal();
            this.gc.cust = this.tables = this.makeCustomizer();
            if (!this.gc.name.equals(proto.getName())) {
                this.logger.info("GribCollectionBuilderFromIndex raf {}: has different name= '{}' than stored in ncx= '{}' ", new Object[]{raf.getLocation(), this.gc.getName(), proto.getName()});
            }
            File protoDir = new File(proto.getTopDir());
            this.gc.setDirectory(protoDir);
            int fsize = 0;
            int n = proto.getMfilesCount();
            HashMap<Integer, MFile> fileMap = new HashMap<Integer, MFile>(2 * n);
            for (i = 0; i < n; ++i) {
                GribCollectionProto.MFile mf = proto.getMfiles(i);
                fileMap.put(mf.getIndex(), new GcMFile(protoDir, mf.getFilename(), mf.getLastModified(), mf.getIndex()));
                fsize += mf.getFilename().length();
            }
            this.gc.setFileMap(fileMap);
            if (this.debug) {
                System.out.printf("GribCollectionBuilderFromIndex files len = %d%n", fsize);
            }
            this.gc.masterRuntime = (CoordinateRuntime)this.readCoord(proto.getMasterRuntime());
            this.gc.horizCS = new ArrayList<GribCollection.HorizCoordSys>(proto.getGdsCount());
            for (i = 0; i < proto.getGdsCount(); ++i) {
                this.readGds(proto.getGds(i));
            }
            this.gc.horizCS = Collections.unmodifiableList(this.gc.horizCS);
            this.gc.datasets = new ArrayList<GribCollection.Dataset>(proto.getDatasetCount());
            for (i = 0; i < proto.getDatasetCount(); ++i) {
                this.readDataset(proto.getDataset(i));
            }
            return this.readExtensions(proto);
        }
        catch (Throwable t) {
            this.logger.warn("Error reading index " + raf.getLocation(), t);
            if (this.debug) {
                t.printStackTrace();
            }
            return false;
        }
    }

    protected boolean readExtensions(GribCollectionProto.GribCollection proto) {
        return true;
    }

    protected GribCollection.VariableIndex readVariableExtensions(GribCollection.GroupGC group, GribCollectionProto.Variable pv, GribCollection.VariableIndex vi) {
        group.addVariable(vi);
        return vi;
    }

    private GribCollection.Dataset readDataset(GribCollectionProto.Dataset p) {
        GribCollection.Type type = GribCollection.Type.valueOf(p.getType().toString());
        GribCollection.Dataset ds = this.gc.makeDataset(type);
        ArrayList<GribCollection.GroupGC> groups = new ArrayList<GribCollection.GroupGC>(p.getGroupsCount());
        for (int i = 0; i < p.getGroupsCount(); ++i) {
            groups.add(this.readGroup(p.getGroups(i)));
        }
        ds.groups = Collections.unmodifiableList(groups);
        return ds;
    }

    protected GribCollection.GroupGC readGroup(GribCollectionProto.Group p) {
        int i;
        GribCollection.GroupGC group = this.gc.makeGroup();
        int gdsIndex = p.getGdsIndex();
        group.horizCoordSys = this.gc.getHorizCS(gdsIndex);
        group.isTwod = p.getIsTwod();
        group.coords = new ArrayList<Coordinate>();
        for (i = 0; i < p.getCoordsCount(); ++i) {
            group.coords.add(this.readCoord(p.getCoords(i)));
        }
        group.filenose = new int[p.getFilenoCount()];
        for (i = 0; i < p.getFilenoCount(); ++i) {
            group.filenose[i] = p.getFileno(i);
        }
        for (i = 0; i < p.getVariablesCount(); ++i) {
            this.readVariable(group, p.getVariables(i));
        }
        int reftimeCoord = 0;
        int timeCoord = 0;
        int ensCoord = 0;
        ArrayList<CoordinateVert> vertCoords = new ArrayList<CoordinateVert>();
        ArrayList<CoordinateTime2D> time2DCoords = new ArrayList<CoordinateTime2D>();
        HashMap<CoordinateRuntime, CoordinateRuntime> runtimes = new HashMap<CoordinateRuntime, CoordinateRuntime>();
        for (Coordinate coord : group.coords) {
            Coordinate.Type type = coord.getType();
            switch (type) {
                case runtime: {
                    CoordinateRuntime reftime = (CoordinateRuntime)coord;
                    if (reftimeCoord > 0) {
                        reftime.setName("reftime" + reftimeCoord);
                    }
                    ++reftimeCoord;
                    runtimes.put(reftime, reftime);
                    break;
                }
                case time: {
                    CoordinateTime tc = (CoordinateTime)coord;
                    if (timeCoord > 0) {
                        tc.setName("time" + timeCoord);
                    }
                    ++timeCoord;
                    break;
                }
                case timeIntv: {
                    CoordinateTimeIntv tci = (CoordinateTimeIntv)coord;
                    if (timeCoord > 0) {
                        tci.setName("time" + timeCoord);
                    }
                    ++timeCoord;
                    break;
                }
                case time2D: {
                    CoordinateTime2D t2d = (CoordinateTime2D)coord;
                    if (timeCoord > 0) {
                        t2d.setName("time" + timeCoord);
                    }
                    ++timeCoord;
                    time2DCoords.add(t2d);
                    break;
                }
                case vert: {
                    vertCoords.add((CoordinateVert)coord);
                    break;
                }
                case ens: {
                    CoordinateEns ce = (CoordinateEns)coord;
                    if (ensCoord > 0) {
                        ce.setName("ens" + ensCoord);
                    }
                    ++ensCoord;
                }
            }
        }
        this.assignVertNames(vertCoords);
        this.assignRuntimeNames(runtimes, time2DCoords, group.getId() + "-" + (group.isTwod ? "TwoD" : "Best"));
        return group;
    }

    public void assignVertNames(List<CoordinateVert> vertCoords) {
        HashMap<String, Integer> map = new HashMap<String, Integer>(2 * vertCoords.size());
        for (CoordinateVert vc : vertCoords) {
            Integer countName;
            String shortName = this.getLevelNameShort(vc.getCode()).toLowerCase();
            if (vc.isLayer()) {
                shortName = shortName + "_layer";
            }
            if ((countName = (Integer)map.get(shortName)) == null) {
                map.put(shortName, 0);
            } else {
                Integer n = countName;
                Integer n2 = countName = Integer.valueOf(countName + 1);
                map.put(shortName, countName);
                shortName = shortName + countName;
            }
            vc.setName(shortName);
        }
    }

    public void assignRuntimeNames(Map<CoordinateRuntime, CoordinateRuntime> runtimes, List<CoordinateTime2D> time2DCoords, String groupId) {
        for (CoordinateTime2D t2d : time2DCoords) {
            CoordinateRuntime runtime2D = t2d.getRuntimeCoordinate();
            CoordinateRuntime runtime = runtimes.get(runtime2D);
            if (runtime == null) {
                System.out.printf("HEY assignRuntimeNames failed on %s group %s%n", t2d.getName(), groupId);
                continue;
            }
            runtime2D.setName(runtime.getName());
        }
    }

    private Coordinate readCoord(GribCollectionProto.Coord pc) {
        int typei = pc.getType();
        int code = pc.getCode();
        String unit = pc.hasUnit() ? pc.getUnit() : null;
        Coordinate.Type type = Coordinate.Type.values()[typei];
        switch (type) {
            case runtime: {
                ArrayList<CalendarDate> dates = new ArrayList<CalendarDate>(pc.getMsecsCount());
                for (Long msec : pc.getMsecsList()) {
                    dates.add(CalendarDate.of((long)msec));
                }
                if (unit == null) {
                    throw new IllegalStateException("Null units");
                }
                CalendarDateUnit cdUnit = CalendarDateUnit.of(null, (String)unit);
                return new CoordinateRuntime(dates, cdUnit.getTimeUnit());
            }
            case time: {
                ArrayList<Integer> offs = new ArrayList<Integer>(pc.getValuesCount());
                for (float val : pc.getValuesList()) {
                    offs.add((int)val);
                }
                CalendarDate refDate = CalendarDate.of((long)pc.getMsecs(0));
                if (unit == null) {
                    throw new IllegalStateException("Null units");
                }
                CalendarPeriod timeUnit = CalendarPeriod.of((String)unit);
                return new CoordinateTime(code, timeUnit, refDate, offs);
            }
            case timeIntv: {
                ArrayList<TimeCoord.Tinv> tinvs = new ArrayList<TimeCoord.Tinv>(pc.getValuesCount());
                for (int i = 0; i < pc.getValuesCount(); ++i) {
                    int val1 = (int)pc.getValues(i);
                    int val2 = (int)pc.getBound(i);
                    tinvs.add(new TimeCoord.Tinv(val1, val2));
                }
                CalendarDate refDate = CalendarDate.of((long)pc.getMsecs(0));
                if (unit == null) {
                    throw new IllegalStateException("Null units");
                }
                CalendarPeriod timeUnit2 = CalendarPeriod.of((String)unit);
                return new CoordinateTimeIntv(code, timeUnit2, refDate, tinvs);
            }
            case time2D: {
                boolean isRegular;
                ArrayList<CalendarDate> dates = new ArrayList<CalendarDate>(pc.getMsecsCount());
                for (Long msec : pc.getMsecsList()) {
                    dates.add(CalendarDate.of((long)msec));
                }
                if (unit == null) {
                    throw new IllegalStateException("Null units");
                }
                CalendarPeriod timeUnit3 = CalendarPeriod.of((String)unit);
                CoordinateRuntime runtime = new CoordinateRuntime(dates, timeUnit3);
                ArrayList<Coordinate> times = new ArrayList<Coordinate>(pc.getTimesCount());
                for (GribCollectionProto.Coord coordp : pc.getTimesList()) {
                    times.add(this.readCoord(coordp));
                }
                boolean isOrthogonal = pc.hasIsOrthogonal() && pc.getIsOrthogonal();
                boolean bl = isRegular = pc.hasIsRegular() && pc.getIsRegular();
                if (isOrthogonal) {
                    return new CoordinateTime2D(code, timeUnit3, runtime, (CoordinateTimeAbstract)times.get(0), null);
                }
                if (isRegular) {
                    return new CoordinateTime2D(code, timeUnit3, runtime, times, null);
                }
                return new CoordinateTime2D(code, timeUnit3, null, runtime, times);
            }
            case vert: {
                boolean isLayer = pc.getValuesCount() == pc.getBoundCount();
                ArrayList<VertCoord.Level> levels = new ArrayList<VertCoord.Level>(pc.getValuesCount());
                for (int i = 0; i < pc.getValuesCount(); ++i) {
                    double val1 = pc.getValues(i);
                    double val2 = isLayer ? (double)pc.getBound(i) : -9999.0;
                    levels.add(new VertCoord.Level(val1, val2, isLayer));
                }
                return new CoordinateVert(code, this.tables.getVertUnit(code), levels);
            }
            case ens: {
                ArrayList<EnsCoord.Coord> ecoords = new ArrayList<EnsCoord.Coord>(pc.getValuesCount());
                for (int i = 0; i < pc.getValuesCount(); ++i) {
                    double val1 = pc.getValues(i);
                    double val2 = pc.getBound(i);
                    ecoords.add(new EnsCoord.Coord((int)val1, (int)val2));
                }
                return new CoordinateEns(code, ecoords);
            }
        }
        throw new IllegalStateException("Unknown Coordinate type = " + (Object)((Object)type));
    }

    protected GribCollection.VariableIndex readVariable(GribCollection.GroupGC group, GribCollectionProto.Variable pv) {
        List<Integer> time2runList;
        List<Integer> invCountList;
        int ntimes;
        int discipline = pv.getDiscipline();
        byte[] rawPds = pv.getPds().toByteArray();
        int cdmHash = pv.getCdmHash();
        long recordsPos = pv.getRecordsPos();
        int recordsLen = pv.getRecordsLen();
        List<Integer> index = pv.getCoordIdxList();
        GribCollection.VariableIndex result = this.gc.makeVariableIndex(group, cdmHash, discipline, this.tables, rawPds, index, recordsPos, recordsLen);
        result.density = pv.getDensity();
        result.ndups = pv.getNdups();
        result.nrecords = pv.getNrecords();
        result.missing = pv.getMissing();
        Coordinate runtime = result.getCoordinate(Coordinate.Type.runtime);
        Coordinate time = result.getCoordinate(Coordinate.Type.time);
        if (time == null) {
            time = result.getCoordinate(Coordinate.Type.timeIntv);
        }
        if (time == null) {
            time = result.getCoordinate(Coordinate.Type.time2D);
            ntimes = ((CoordinateTime2D)time).getNtimes();
        } else {
            ntimes = time.getSize();
        }
        if (!this.dataOnly && (invCountList = pv.getInvCountList()).size() > 0) {
            result.twot = new TwoDTimeInventory(invCountList);
            result.twot.setSize(runtime.getSize(), ntimes);
        }
        if ((time2runList = pv.getTime2RuntimeList()).size() > 0) {
            result.time2runtime = new int[time2runList.size()];
            int count = 0;
            for (int idx : time2runList) {
                result.time2runtime[count++] = idx;
            }
        }
        return this.readVariableExtensions(group, pv, result);
    }
}

