/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.openai.internal.chat;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import dev.langchain4j.internal.JacocoIgnoreCoverageGenerated;
import dev.langchain4j.model.openai.internal.chat.Function;
import dev.langchain4j.model.openai.internal.chat.ToolType;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public class ToolChoice {
    @JsonProperty
    private final ToolType type = ToolType.FUNCTION;
    @JsonProperty
    private final Function function;

    public ToolChoice(Builder builder) {
        this.function = builder.function;
    }

    @JacocoIgnoreCoverageGenerated
    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ToolChoice && this.equalTo((ToolChoice)another);
    }

    @JacocoIgnoreCoverageGenerated
    private boolean equalTo(ToolChoice another) {
        return Objects.equals((Object)this.type, (Object)another.type) && Objects.equals(this.function, another.function);
    }

    @JacocoIgnoreCoverageGenerated
    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode((Object)this.type);
        h += (h << 5) + Objects.hashCode(this.function);
        return h;
    }

    @JacocoIgnoreCoverageGenerated
    public String toString() {
        return "ToolChoice{type=" + String.valueOf((Object)this.type) + ", function=" + String.valueOf(this.function) + "}";
    }

    public static ToolChoice from(String functionName) {
        return new Builder().function(Function.builder().name(functionName).build()).build();
    }

    @JsonPOJOBuilder(withPrefix="")
    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    public static final class Builder {
        private Function function;

        public Builder function(Function function) {
            this.function = function;
            return this;
        }

        public ToolChoice build() {
            return new ToolChoice(this);
        }
    }
}

