/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.openai;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.data.image.Image;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.Content;
import dev.langchain4j.data.message.ImageContent;
import dev.langchain4j.data.message.SystemMessage;
import dev.langchain4j.data.message.TextContent;
import dev.langchain4j.data.message.ToolExecutionResultMessage;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.exception.UnsupportedFeatureException;
import dev.langchain4j.http.client.HttpClient;
import dev.langchain4j.http.client.HttpClientBuilder;
import dev.langchain4j.http.client.HttpClientBuilderLoader;
import dev.langchain4j.http.client.HttpMethod;
import dev.langchain4j.http.client.HttpRequest;
import dev.langchain4j.http.client.SuccessfulHttpResponse;
import dev.langchain4j.http.client.log.LoggingHttpClient;
import dev.langchain4j.http.client.sse.CancellationUnsupportedHandle;
import dev.langchain4j.http.client.sse.DefaultServerSentEventParser;
import dev.langchain4j.http.client.sse.ServerSentEvent;
import dev.langchain4j.http.client.sse.ServerSentEventContext;
import dev.langchain4j.http.client.sse.ServerSentEventListener;
import dev.langchain4j.http.client.sse.ServerSentEventParser;
import dev.langchain4j.http.client.sse.ServerSentEventParsingHandle;
import dev.langchain4j.http.client.sse.ServerSentEventParsingHandleUtils;
import dev.langchain4j.internal.ExceptionMapper;
import dev.langchain4j.internal.InternalStreamingChatResponseHandlerUtils;
import dev.langchain4j.internal.JsonSchemaElementUtils;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.chat.request.ChatRequest;
import dev.langchain4j.model.chat.request.ChatRequestParameters;
import dev.langchain4j.model.chat.request.ResponseFormat;
import dev.langchain4j.model.chat.request.ResponseFormatType;
import dev.langchain4j.model.chat.request.ToolChoice;
import dev.langchain4j.model.chat.request.json.JsonObjectSchema;
import dev.langchain4j.model.chat.request.json.JsonRawSchema;
import dev.langchain4j.model.chat.request.json.JsonSchema;
import dev.langchain4j.model.chat.request.json.JsonSchemaElement;
import dev.langchain4j.model.chat.response.ChatResponse;
import dev.langchain4j.model.chat.response.ChatResponseMetadata;
import dev.langchain4j.model.chat.response.CompleteToolCall;
import dev.langchain4j.model.chat.response.StreamingChatResponseHandler;
import dev.langchain4j.model.chat.response.StreamingHandle;
import dev.langchain4j.model.openai.OpenAiChatResponseMetadata;
import dev.langchain4j.model.openai.OpenAiResponsesConfig;
import dev.langchain4j.model.openai.OpenAiTokenUsage;
import dev.langchain4j.model.output.FinishReason;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class OpenAiResponsesClient {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final String DEFAULT_BASE_URL = "https://api.openai.com/v1";
    private static final String OPENAI_ORGANIZATION_HEADER = "OpenAI-Organization";
    private static final String STREAM_DONE_MARKER = "[DONE]";
    private static final String EVENT_OUTPUT_TEXT_DELTA = "response.output_text.delta";
    private static final String EVENT_OUTPUT_ITEM_ADDED = "response.output_item.added";
    private static final String EVENT_FUNCTION_CALL_ARGUMENTS_DELTA = "response.function_call_arguments.delta";
    private static final String EVENT_FUNCTION_CALL_ARGUMENTS_DONE = "response.function_call_arguments.done";
    private static final String EVENT_OUTPUT_ITEM_DONE = "response.output_item.done";
    private static final String EVENT_RESPONSE_COMPLETED = "response.completed";
    private static final String FIELD_TYPE = "type";
    private static final String FIELD_ROLE = "role";
    private static final String FIELD_CONTENT = "content";
    private static final String FIELD_NAME = "name";
    private static final String FIELD_DESCRIPTION = "description";
    private static final String FIELD_PARAMETERS = "parameters";
    private static final String FIELD_PROPERTIES = "properties";
    private static final String FIELD_ARGUMENTS = "arguments";
    private static final String FIELD_DELTA = "delta";
    private static final String FIELD_TEXT = "text";
    private static final String FIELD_IMAGE_URL = "image_url";
    private static final String FIELD_DETAIL = "detail";
    private static final String FIELD_ITEM = "item";
    private static final String FIELD_ID = "id";
    private static final String FIELD_CALL_ID = "call_id";
    private static final String FIELD_ITEM_ID = "item_id";
    private static final String FIELD_OUTPUT_INDEX = "output_index";
    private static final String FIELD_RESPONSE = "response";
    private static final String FIELD_OUTPUT = "output";
    private static final String FIELD_USAGE = "usage";
    private static final String FIELD_INPUT_TOKENS = "input_tokens";
    private static final String FIELD_OUTPUT_TOKENS = "output_tokens";
    private static final String FIELD_TOTAL_TOKENS = "total_tokens";
    private static final String FIELD_INPUT_TOKENS_DETAILS = "input_tokens_details";
    private static final String FIELD_CACHED_TOKENS = "cached_tokens";
    private static final String FIELD_MODEL = "model";
    private static final String FIELD_INPUT = "input";
    private static final String FIELD_STREAM = "stream";
    private static final String FIELD_STORE = "store";
    private static final String FIELD_TEMPERATURE = "temperature";
    private static final String FIELD_TOP_P = "top_p";
    private static final String FIELD_MAX_OUTPUT_TOKENS = "max_output_tokens";
    private static final String FIELD_MAX_TOOL_CALLS = "max_tool_calls";
    private static final String FIELD_PARALLEL_TOOL_CALLS = "parallel_tool_calls";
    private static final String FIELD_PREVIOUS_RESPONSE_ID = "previous_response_id";
    private static final String FIELD_TOP_LOGPROBS = "top_logprobs";
    private static final String FIELD_TOOLS = "tools";
    private static final String FIELD_TOOL_CHOICE = "tool_choice";
    private static final String FIELD_TRUNCATION = "truncation";
    private static final String FIELD_INCLUDE = "include";
    private static final String FIELD_SERVICE_TIER = "service_tier";
    private static final String FIELD_SAFETY_IDENTIFIER = "safety_identifier";
    private static final String FIELD_PROMPT_CACHE_KEY = "prompt_cache_key";
    private static final String FIELD_PROMPT_CACHE_RETENTION = "prompt_cache_retention";
    private static final String FIELD_REASONING = "reasoning";
    private static final String FIELD_EFFORT = "effort";
    private static final String FIELD_STRICT = "strict";
    private static final String FIELD_STREAM_OPTIONS = "stream_options";
    private static final String FIELD_INCLUDE_OBFUSCATION = "include_obfuscation";
    private static final String FIELD_TEXT_VERBOSITY = "verbosity";
    private static final String FIELD_FORMAT = "format";
    private static final String FIELD_JSON_SCHEMA = "json_schema";
    private static final String FIELD_SCHEMA = "schema";
    private static final String FIELD_ADDITIONAL_PROPERTIES = "additionalProperties";
    private static final String FIELD_STATUS = "status";
    private static final String FIELD_CREATED = "created";
    private static final String FIELD_SYSTEM_FINGERPRINT = "system_fingerprint";
    private static final String DETAIL_AUTO_VALUE = "auto";
    private static final String DEFAULT_IMAGE_MIME_TYPE = "image/jpeg";
    private static final String ROLE_SYSTEM = "system";
    private static final String ROLE_USER = "user";
    private static final String ROLE_ASSISTANT = "assistant";
    private static final String TYPE_FUNCTION = "function";
    private static final String TYPE_FUNCTION_CALL = "function_call";
    private static final String TYPE_MESSAGE = "message";
    private static final String TYPE_OUTPUT_TEXT = "output_text";
    private static final String TYPE_OBJECT = "object";
    private static final String TYPE_INPUT_TEXT = "input_text";
    private static final String TYPE_INPUT_IMAGE = "input_image";
    private static final String TYPE_FUNCTION_CALL_OUTPUT = "function_call_output";
    private static final String TYPE_JSON_OBJECT = "json_object";
    private static final String TYPE_JSON_SCHEMA = "json_schema";
    private final HttpClient httpClient;
    private final String baseUrl;
    private final String apiKey;
    private final String organizationId;

    OpenAiResponsesClient(Builder builder) {
        HttpClientBuilder httpClientBuilder = (HttpClientBuilder)Utils.getOrDefault((Object)builder.httpClientBuilder, HttpClientBuilderLoader::loadHttpClientBuilder);
        HttpClient httpClient = httpClientBuilder.build();
        this.httpClient = builder.logRequests || builder.logResponses ? new LoggingHttpClient(httpClient, Boolean.valueOf(builder.logRequests), Boolean.valueOf(builder.logResponses)) : httpClient;
        this.baseUrl = (String)Utils.getOrDefault((Object)builder.baseUrl, (Object)DEFAULT_BASE_URL);
        this.apiKey = builder.apiKey;
        this.organizationId = builder.organizationId;
    }

    static Builder builder() {
        return new Builder();
    }

    void streamingChat(ChatRequest chatRequest, OpenAiResponsesConfig config, StreamingChatResponseHandler handler) {
        try {
            Map<String, Object> payload = this.buildRequestPayload(chatRequest, config);
            HttpRequest request = this.buildHttpRequest(payload);
            this.httpClient.execute(request, (ServerSentEventParser)new DefaultServerSentEventParser(), (ServerSentEventListener)new ResponsesApiEventListener(handler));
        }
        catch (Exception e) {
            InternalStreamingChatResponseHandlerUtils.withLoggingExceptions(() -> handler.onError((Throwable)ExceptionMapper.DEFAULT.mapException((Throwable)e)));
        }
    }

    private Map<String, Object> buildRequestPayload(ChatRequest chatRequest, OpenAiResponsesConfig config) {
        List toolSpecifications;
        Integer effectiveMaxOutputTokens;
        Double effectiveTopP;
        Double effectiveTemperature;
        ChatRequestParameters parameters = chatRequest.parameters();
        ArrayList<Map<String, Object>> input = new ArrayList<Map<String, Object>>();
        for (ChatMessage msg : chatRequest.messages()) {
            input.addAll(this.toResponsesMessages(msg));
        }
        HashMap<String, Object> payload = new HashMap<String, Object>();
        String effectiveModelName = parameters != null && parameters.modelName() != null ? parameters.modelName() : config.modelName();
        payload.put(FIELD_MODEL, effectiveModelName);
        payload.put(FIELD_INPUT, input);
        payload.put(FIELD_STREAM, true);
        payload.put(FIELD_STORE, config.store());
        Double d = effectiveTemperature = parameters != null && parameters.temperature() != null ? parameters.temperature() : config.temperature();
        if (effectiveTemperature != null) {
            payload.put(FIELD_TEMPERATURE, effectiveTemperature);
        }
        Double d2 = effectiveTopP = parameters != null && parameters.topP() != null ? parameters.topP() : config.topP();
        if (effectiveTopP != null) {
            payload.put(FIELD_TOP_P, effectiveTopP);
        }
        Integer requestMaxOutputTokens = parameters != null ? parameters.maxOutputTokens() : null;
        Integer n = effectiveMaxOutputTokens = requestMaxOutputTokens != null ? requestMaxOutputTokens : config.maxOutputTokens();
        if (effectiveMaxOutputTokens != null) {
            payload.put(FIELD_MAX_OUTPUT_TOKENS, effectiveMaxOutputTokens);
        }
        if (config.maxToolCalls() != null) {
            payload.put(FIELD_MAX_TOOL_CALLS, config.maxToolCalls());
        }
        if (config.parallelToolCalls() != null) {
            payload.put(FIELD_PARALLEL_TOOL_CALLS, config.parallelToolCalls());
        }
        if (config.previousResponseId() != null) {
            payload.put(FIELD_PREVIOUS_RESPONSE_ID, config.previousResponseId());
        }
        if (config.topLogprobs() != null) {
            payload.put(FIELD_TOP_LOGPROBS, config.topLogprobs());
        }
        if (config.truncation() != null && !config.truncation().isEmpty()) {
            payload.put(FIELD_TRUNCATION, config.truncation());
        }
        if (config.include() != null && !config.include().isEmpty()) {
            payload.put(FIELD_INCLUDE, config.include());
        }
        if (config.serviceTier() != null && !config.serviceTier().isEmpty()) {
            payload.put(FIELD_SERVICE_TIER, config.serviceTier());
        }
        if (config.safetyIdentifier() != null) {
            payload.put(FIELD_SAFETY_IDENTIFIER, config.safetyIdentifier());
        }
        if (config.promptCacheKey() != null) {
            payload.put(FIELD_PROMPT_CACHE_KEY, config.promptCacheKey());
        }
        if (config.promptCacheRetention() != null) {
            payload.put(FIELD_PROMPT_CACHE_RETENTION, config.promptCacheRetention());
        }
        if (config.reasoningEffort() != null && !config.reasoningEffort().isEmpty()) {
            HashMap<String, String> reasoning = new HashMap<String, String>();
            reasoning.put(FIELD_EFFORT, config.reasoningEffort());
            payload.put(FIELD_REASONING, reasoning);
        }
        if (config.streamIncludeObfuscation() != null) {
            HashMap<String, Boolean> streamOptions = new HashMap<String, Boolean>();
            streamOptions.put(FIELD_INCLUDE_OBFUSCATION, config.streamIncludeObfuscation());
            payload.put(FIELD_STREAM_OPTIONS, streamOptions);
        }
        if ((toolSpecifications = chatRequest.toolSpecifications()) != null && !toolSpecifications.isEmpty()) {
            ArrayList tools = new ArrayList();
            for (ToolSpecification toolSpec : toolSpecifications) {
                HashMap<String, Object> tool = new HashMap<String, Object>();
                tool.put(FIELD_TYPE, TYPE_FUNCTION);
                tool.put(FIELD_NAME, toolSpec.name());
                if (toolSpec.description() != null) {
                    tool.put(FIELD_DESCRIPTION, toolSpec.description());
                }
                HashMap<String, Object> functionParameters = null;
                if (toolSpec.parameters() != null) {
                    functionParameters = JsonSchemaElementUtils.toMap((JsonSchemaElement)toolSpec.parameters(), (boolean)config.strict());
                } else if (config.strict().booleanValue()) {
                    functionParameters = new HashMap<String, Object>();
                    functionParameters.put(FIELD_TYPE, TYPE_OBJECT);
                    functionParameters.put(FIELD_PROPERTIES, new HashMap());
                    functionParameters.put(FIELD_ADDITIONAL_PROPERTIES, false);
                }
                if (functionParameters != null) {
                    tool.put(FIELD_PARAMETERS, functionParameters);
                }
                if (config.strict().booleanValue()) {
                    tool.put(FIELD_STRICT, true);
                }
                tools.add(tool);
            }
            payload.put(FIELD_TOOLS, tools);
            if (chatRequest.toolChoice() != null) {
                payload.put(FIELD_TOOL_CHOICE, this.toToolChoiceString(chatRequest.toolChoice()));
            } else {
                payload.put(FIELD_TOOL_CHOICE, DETAIL_AUTO_VALUE);
            }
        }
        Map<String, Object> textConfig = this.toResponseTextConfig(chatRequest.responseFormat(), config.strict());
        if (config.textVerbosity() != null) {
            if (textConfig == null) {
                textConfig = new HashMap<String, Object>();
            }
            textConfig.put(FIELD_TEXT_VERBOSITY, config.textVerbosity());
        }
        if (textConfig != null) {
            payload.put(FIELD_TEXT, textConfig);
        }
        return payload;
    }

    private HttpRequest buildHttpRequest(Map<String, Object> payload) throws Exception {
        String requestBody = OBJECT_MAPPER.writeValueAsString(payload);
        HttpRequest.Builder requestBuilder = HttpRequest.builder().url(this.baseUrl + "/responses").method(HttpMethod.POST).addHeader("Authorization", new String[]{"Bearer " + this.apiKey}).addHeader("Content-Type", new String[]{"application/json"}).addHeader("Accept", new String[]{"text/event-stream"});
        if (this.organizationId != null) {
            requestBuilder.addHeader(OPENAI_ORGANIZATION_HEADER, new String[]{this.organizationId});
        }
        return requestBuilder.body(requestBody).build();
    }

    private List<Map<String, Object>> toResponsesMessages(ChatMessage msg) {
        if (msg instanceof SystemMessage) {
            SystemMessage systemMessage = (SystemMessage)msg;
            return List.of(this.createMessageEntry(ROLE_SYSTEM, List.of(this.createInputTextContent(systemMessage.text()))));
        }
        if (msg instanceof UserMessage) {
            UserMessage userMessage = (UserMessage)msg;
            ArrayList<Map<String, Object>> contentEntries = new ArrayList<Map<String, Object>>();
            for (Content content : userMessage.contents()) {
                if (content instanceof TextContent) {
                    TextContent textContent = (TextContent)content;
                    contentEntries.add(this.createInputTextContent(textContent.text()));
                    continue;
                }
                if (content instanceof ImageContent) {
                    ImageContent imageContent = (ImageContent)content;
                    contentEntries.add(this.createInputImageContent(imageContent.image()));
                    continue;
                }
                throw new UnsupportedFeatureException("Unsupported content type: " + content.getClass().getName() + ". Only TextContent and ImageContent are supported.");
            }
            return List.of(this.createMessageEntry(ROLE_USER, contentEntries));
        }
        if (msg instanceof AiMessage) {
            AiMessage aiMessage = (AiMessage)msg;
            ArrayList<Map<String, Object>> items = new ArrayList<Map<String, Object>>();
            String text = aiMessage.text();
            if (text != null && !text.isEmpty()) {
                items.add(this.createMessageEntry(ROLE_ASSISTANT, List.of(this.createInputTextContent(text))));
            }
            if (aiMessage.hasToolExecutionRequests()) {
                for (ToolExecutionRequest toolRequest : aiMessage.toolExecutionRequests()) {
                    HashMap<String, String> functionCall = new HashMap<String, String>();
                    functionCall.put(FIELD_TYPE, TYPE_FUNCTION_CALL);
                    functionCall.put(FIELD_CALL_ID, toolRequest.id());
                    functionCall.put(FIELD_NAME, toolRequest.name());
                    functionCall.put(FIELD_ARGUMENTS, toolRequest.arguments());
                    items.add(functionCall);
                }
            }
            return items;
        }
        if (msg instanceof ToolExecutionResultMessage) {
            ToolExecutionResultMessage toolExecutionResultMessage = (ToolExecutionResultMessage)msg;
            HashMap<String, String> outputEntry = new HashMap<String, String>();
            outputEntry.put(FIELD_TYPE, TYPE_FUNCTION_CALL_OUTPUT);
            outputEntry.put(FIELD_CALL_ID, toolExecutionResultMessage.id());
            outputEntry.put(FIELD_OUTPUT, toolExecutionResultMessage.text());
            return List.of(outputEntry);
        }
        throw new UnsupportedFeatureException("Unsupported message type: " + msg.getClass().getName() + ". Only SystemMessage, UserMessage, AiMessage, and ToolExecutionResultMessage are supported.");
    }

    private Map<String, Object> createMessageEntry(String role, List<Map<String, Object>> contentEntries) {
        HashMap<String, Object> entry = new HashMap<String, Object>();
        entry.put(FIELD_TYPE, TYPE_MESSAGE);
        entry.put(FIELD_ROLE, role);
        entry.put(FIELD_CONTENT, contentEntries);
        return entry;
    }

    private Map<String, Object> createInputTextContent(String text) {
        HashMap<String, Object> content = new HashMap<String, Object>();
        content.put(FIELD_TYPE, TYPE_INPUT_TEXT);
        content.put(FIELD_TEXT, text);
        return content;
    }

    private Map<String, Object> createInputImageContent(Image image) {
        HashMap<String, Object> content = new HashMap<String, Object>();
        content.put(FIELD_TYPE, TYPE_INPUT_IMAGE);
        content.put(FIELD_IMAGE_URL, this.buildImageUrl(image));
        content.put(FIELD_DETAIL, DETAIL_AUTO_VALUE);
        return content;
    }

    private String buildImageUrl(Image image) {
        if (image.url() != null) {
            return image.url().toString();
        }
        if (image.base64Data() != null) {
            String mimeType = image.mimeType() != null ? image.mimeType() : DEFAULT_IMAGE_MIME_TYPE;
            return "data:" + mimeType + ";base64," + image.base64Data();
        }
        throw new IllegalArgumentException("Image must have either url or base64Data");
    }

    private String toToolChoiceString(ToolChoice toolChoice) {
        if (toolChoice == null) {
            return null;
        }
        return switch (toolChoice) {
            default -> throw new IncompatibleClassChangeError();
            case ToolChoice.AUTO -> DETAIL_AUTO_VALUE;
            case ToolChoice.REQUIRED -> "required";
            case ToolChoice.NONE -> "none";
        };
    }

    private Map<String, Object> toResponseTextConfig(ResponseFormat responseFormat, boolean strict) {
        if (responseFormat == null || responseFormat.type() == ResponseFormatType.TEXT) {
            return null;
        }
        HashMap<String, Object> textConfig = new HashMap<String, Object>();
        JsonSchema jsonSchema = responseFormat.jsonSchema();
        if (jsonSchema == null) {
            HashMap<String, String> format = new HashMap<String, String>();
            format.put(FIELD_TYPE, TYPE_JSON_OBJECT);
            textConfig.put(FIELD_FORMAT, format);
        } else {
            if (!(jsonSchema.rootElement() instanceof JsonObjectSchema) && !(jsonSchema.rootElement() instanceof JsonRawSchema)) {
                throw new IllegalArgumentException("For OpenAI Responses API, the root element of the JSON Schema must be either a JsonObjectSchema or a JsonRawSchema, but it was: " + String.valueOf(jsonSchema.rootElement().getClass()));
            }
            Map schemaMap = JsonSchemaElementUtils.toMap((JsonSchemaElement)jsonSchema.rootElement(), (boolean)strict);
            HashMap<String, Object> format = new HashMap<String, Object>();
            format.put(FIELD_TYPE, "json_schema");
            if (jsonSchema.name() != null) {
                format.put(FIELD_NAME, jsonSchema.name());
            }
            HashMap<String, Object> jsonSchemaConfig = new HashMap<String, Object>();
            jsonSchemaConfig.put(FIELD_SCHEMA, schemaMap);
            jsonSchemaConfig.put(FIELD_STRICT, strict);
            if (jsonSchema.name() != null) {
                jsonSchemaConfig.put(FIELD_NAME, jsonSchema.name());
            }
            format.put(FIELD_SCHEMA, schemaMap);
            format.put("json_schema", jsonSchemaConfig);
            textConfig.put(FIELD_FORMAT, format);
        }
        return textConfig;
    }

    static class Builder {
        private HttpClientBuilder httpClientBuilder;
        private String baseUrl;
        private String apiKey;
        private String organizationId;
        private boolean logRequests;
        private boolean logResponses;

        Builder() {
        }

        Builder httpClientBuilder(HttpClientBuilder httpClientBuilder) {
            this.httpClientBuilder = httpClientBuilder;
            return this;
        }

        Builder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        Builder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        Builder organizationId(String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        Builder logRequests(Boolean logRequests) {
            if (logRequests != null) {
                this.logRequests = logRequests;
            }
            return this;
        }

        Builder logResponses(Boolean logResponses) {
            if (logResponses != null) {
                this.logResponses = logResponses;
            }
            return this;
        }

        OpenAiResponsesClient build() {
            return new OpenAiResponsesClient(this);
        }
    }

    private static class ResponsesApiEventListener
    implements ServerSentEventListener {
        private final StreamingChatResponseHandler handler;
        private volatile StreamingHandle streamingHandle;
        private final Map<String, ToolExecutionRequest.Builder> toolCallBuilders = new HashMap<String, ToolExecutionRequest.Builder>();
        private final Map<String, Integer> toolCallIndices = new HashMap<String, Integer>();
        private final List<ToolExecutionRequest> completedToolCalls = new ArrayList<ToolExecutionRequest>();
        private final Set<String> completedToolCallItemIds = new HashSet<String>();
        private final List<ServerSentEvent> rawServerSentEvents = new ArrayList<ServerSentEvent>();
        private SuccessfulHttpResponse rawHttpResponse;

        ResponsesApiEventListener(StreamingChatResponseHandler handler) {
            this.handler = handler;
        }

        private boolean isCancelled() {
            return this.streamingHandle != null && this.streamingHandle.isCancelled();
        }

        private void assignIndexIfAbsent(String itemId, int index) {
            this.toolCallIndices.putIfAbsent(itemId, index);
        }

        public void onOpen(SuccessfulHttpResponse response) {
            this.rawHttpResponse = response;
        }

        public void onEvent(ServerSentEvent event) {
            this.onEvent(event, new ServerSentEventContext((ServerSentEventParsingHandle)new CancellationUnsupportedHandle()));
        }

        public void onEvent(ServerSentEvent event, ServerSentEventContext context) {
            if (this.streamingHandle == null) {
                this.streamingHandle = ServerSentEventParsingHandleUtils.toStreamingHandle((ServerSentEventParsingHandle)context.parsingHandle());
            }
            if (this.isCancelled()) {
                return;
            }
            this.rawServerSentEvents.add(event);
            String data = event.data();
            if (data == null || data.isEmpty()) {
                return;
            }
            if (OpenAiResponsesClient.STREAM_DONE_MARKER.equals(data)) {
                return;
            }
            this.handleDelta(data);
        }

        public void onError(Throwable error) {
            InternalStreamingChatResponseHandlerUtils.withLoggingExceptions(() -> this.handler.onError((Throwable)ExceptionMapper.DEFAULT.mapException(error)));
        }

        private void handleDelta(String data) {
            if (!data.trim().startsWith("{") && !data.trim().startsWith("[")) {
                return;
            }
            try {
                String type;
                JsonNode node = OBJECT_MAPPER.readTree(data);
                String string = type = node.has(OpenAiResponsesClient.FIELD_TYPE) ? node.get(OpenAiResponsesClient.FIELD_TYPE).asText() : "";
                if (OpenAiResponsesClient.EVENT_OUTPUT_TEXT_DELTA.equals(type)) {
                    String text = node.path(OpenAiResponsesClient.FIELD_DELTA).asText();
                    if (!text.isEmpty()) {
                        InternalStreamingChatResponseHandlerUtils.onPartialResponse((StreamingChatResponseHandler)this.handler, (String)text, (StreamingHandle)this.streamingHandle);
                    }
                } else if (OpenAiResponsesClient.EVENT_OUTPUT_ITEM_ADDED.equals(type)) {
                    JsonNode item = node.path(OpenAiResponsesClient.FIELD_ITEM);
                    if (OpenAiResponsesClient.TYPE_FUNCTION_CALL.equals(item.path(OpenAiResponsesClient.FIELD_TYPE).asText())) {
                        String itemId = item.path(OpenAiResponsesClient.FIELD_ID).asText();
                        int outputIndex = node.path(OpenAiResponsesClient.FIELD_OUTPUT_INDEX).asInt(0);
                        this.toolCallBuilders.put(itemId, ToolExecutionRequest.builder().id(item.path(OpenAiResponsesClient.FIELD_CALL_ID).asText()).name(item.path(OpenAiResponsesClient.FIELD_NAME).asText()).arguments(""));
                        this.assignIndexIfAbsent(itemId, outputIndex);
                    }
                } else if (OpenAiResponsesClient.EVENT_FUNCTION_CALL_ARGUMENTS_DELTA.equals(type)) {
                    String itemId = node.path(OpenAiResponsesClient.FIELD_ITEM_ID).asText();
                    ToolExecutionRequest.Builder builder = this.toolCallBuilders.get(itemId);
                    if (builder != null) {
                        String currentArgs = builder.build().arguments();
                        builder.arguments(currentArgs + node.path(OpenAiResponsesClient.FIELD_DELTA).asText());
                    }
                } else if (OpenAiResponsesClient.EVENT_FUNCTION_CALL_ARGUMENTS_DONE.equals(type)) {
                    String itemId = node.path(OpenAiResponsesClient.FIELD_ITEM_ID).asText();
                    ToolExecutionRequest.Builder builder = this.toolCallBuilders.get(itemId);
                    if (builder != null) {
                        builder.arguments(node.path(OpenAiResponsesClient.FIELD_ARGUMENTS).asText());
                        this.completeToolCall(itemId, builder);
                    }
                } else if (OpenAiResponsesClient.EVENT_OUTPUT_ITEM_DONE.equals(type)) {
                    this.handleOutputItemDone(node);
                } else if (OpenAiResponsesClient.EVENT_RESPONSE_COMPLETED.equals(type)) {
                    this.handleResponseCompleted(node);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private void handleOutputItemDone(JsonNode node) {
            JsonNode item = node.path(OpenAiResponsesClient.FIELD_ITEM);
            if (OpenAiResponsesClient.TYPE_FUNCTION_CALL.equals(item.path(OpenAiResponsesClient.FIELD_TYPE).asText())) {
                JsonNode argumentsNode;
                JsonNode nameNode;
                String itemId = item.path(OpenAiResponsesClient.FIELD_ID).asText();
                int outputIndex = node.path(OpenAiResponsesClient.FIELD_OUTPUT_INDEX).asInt(0);
                ToolExecutionRequest.Builder builder = this.toolCallBuilders.computeIfAbsent(itemId, ignored -> ToolExecutionRequest.builder());
                this.assignIndexIfAbsent(itemId, outputIndex);
                JsonNode callIdNode = item.get(OpenAiResponsesClient.FIELD_CALL_ID);
                if (callIdNode != null && !callIdNode.isNull()) {
                    builder.id(callIdNode.asText());
                }
                if ((nameNode = item.get(OpenAiResponsesClient.FIELD_NAME)) != null && !nameNode.isNull()) {
                    builder.name(nameNode.asText());
                }
                if ((argumentsNode = item.get(OpenAiResponsesClient.FIELD_ARGUMENTS)) != null && !argumentsNode.isNull()) {
                    builder.arguments(argumentsNode.asText());
                }
                this.completeToolCall(itemId, builder);
            }
        }

        private void handleResponseCompleted(JsonNode node) {
            StringBuilder sb = new StringBuilder();
            JsonNode responseNode = node.path(OpenAiResponsesClient.FIELD_RESPONSE);
            JsonNode output = responseNode.path(OpenAiResponsesClient.FIELD_OUTPUT);
            if (output.isArray()) {
                for (JsonNode item : output) {
                    JsonNode content;
                    if (!OpenAiResponsesClient.TYPE_MESSAGE.equals(item.path(OpenAiResponsesClient.FIELD_TYPE).asText()) || !(content = item.path(OpenAiResponsesClient.FIELD_CONTENT)).isArray()) continue;
                    for (JsonNode c : content) {
                        if (!OpenAiResponsesClient.TYPE_OUTPUT_TEXT.equals(c.path(OpenAiResponsesClient.FIELD_TYPE).asText())) continue;
                        sb.append(c.path(OpenAiResponsesClient.FIELD_TEXT).asText());
                    }
                }
            }
            OpenAiTokenUsage tokenUsage = null;
            JsonNode usageNode = responseNode.path(OpenAiResponsesClient.FIELD_USAGE);
            if (!usageNode.isMissingNode()) {
                int cachedTokens;
                OpenAiTokenUsage.Builder usageBuilder = OpenAiTokenUsage.builder().inputTokenCount(usageNode.path(OpenAiResponsesClient.FIELD_INPUT_TOKENS).asInt()).outputTokenCount(usageNode.path(OpenAiResponsesClient.FIELD_OUTPUT_TOKENS).asInt()).totalTokenCount(usageNode.path(OpenAiResponsesClient.FIELD_TOTAL_TOKENS).asInt());
                JsonNode inputDetailsNode = usageNode.path(OpenAiResponsesClient.FIELD_INPUT_TOKENS_DETAILS);
                if (!inputDetailsNode.isMissingNode() && (cachedTokens = inputDetailsNode.path(OpenAiResponsesClient.FIELD_CACHED_TOKENS).asInt()) > 0) {
                    usageBuilder.inputTokensDetails(OpenAiTokenUsage.InputTokensDetails.builder().cachedTokens(cachedTokens).build());
                }
                tokenUsage = usageBuilder.build();
            }
            if (!sb.isEmpty() || !this.completedToolCalls.isEmpty()) {
                FinishReason finishReason;
                String text;
                String string = text = sb.isEmpty() ? null : sb.toString();
                AiMessage aiMessage = !this.completedToolCalls.isEmpty() && text != null ? new AiMessage(text, this.completedToolCalls) : (!this.completedToolCalls.isEmpty() ? AiMessage.from(this.completedToolCalls) : new AiMessage(sb.toString()));
                ChatResponse.Builder responseBuilder = ChatResponse.builder().aiMessage(aiMessage);
                OpenAiChatResponseMetadata.Builder metadataBuilder = (OpenAiChatResponseMetadata.Builder)((OpenAiChatResponseMetadata.Builder)OpenAiChatResponseMetadata.builder().id(responseNode.path(OpenAiResponsesClient.FIELD_ID).asText(null))).modelName(responseNode.path(OpenAiResponsesClient.FIELD_MODEL).asText(null));
                if (responseNode.hasNonNull(OpenAiResponsesClient.FIELD_CREATED)) {
                    metadataBuilder.created(responseNode.path(OpenAiResponsesClient.FIELD_CREATED).asLong());
                }
                if (responseNode.hasNonNull(OpenAiResponsesClient.FIELD_SERVICE_TIER)) {
                    metadataBuilder.serviceTier(responseNode.path(OpenAiResponsesClient.FIELD_SERVICE_TIER).asText());
                }
                if (responseNode.hasNonNull(OpenAiResponsesClient.FIELD_SYSTEM_FINGERPRINT)) {
                    metadataBuilder.systemFingerprint(responseNode.path(OpenAiResponsesClient.FIELD_SYSTEM_FINGERPRINT).asText());
                }
                if (tokenUsage != null) {
                    metadataBuilder.tokenUsage(tokenUsage);
                }
                if ((finishReason = this.determineFinishReason(responseNode.path(OpenAiResponsesClient.FIELD_STATUS).asText(null))) != null) {
                    metadataBuilder.finishReason(finishReason);
                }
                if (this.rawHttpResponse != null) {
                    metadataBuilder.rawHttpResponse(this.rawHttpResponse);
                }
                if (!this.rawServerSentEvents.isEmpty()) {
                    metadataBuilder.rawServerSentEvents(new ArrayList<ServerSentEvent>(this.rawServerSentEvents));
                }
                responseBuilder.metadata((ChatResponseMetadata)metadataBuilder.build());
                if (!this.isCancelled()) {
                    try {
                        this.handler.onCompleteResponse(responseBuilder.build());
                    }
                    catch (Exception e) {
                        InternalStreamingChatResponseHandlerUtils.withLoggingExceptions(() -> this.handler.onError((Throwable)e));
                    }
                }
            }
        }

        private FinishReason determineFinishReason(String status) {
            if (status == null || status.isBlank()) {
                return null;
            }
            return switch (status) {
                case "completed" -> {
                    if (!this.completedToolCalls.isEmpty()) {
                        yield FinishReason.TOOL_EXECUTION;
                    }
                    yield FinishReason.STOP;
                }
                case "incomplete" -> FinishReason.LENGTH;
                case "failed" -> FinishReason.OTHER;
                default -> FinishReason.OTHER;
            };
        }

        private void completeToolCall(String itemId, ToolExecutionRequest.Builder builder) {
            int safeIndex;
            if (builder == null || this.completedToolCallItemIds.contains(itemId)) {
                return;
            }
            ToolExecutionRequest toolExecutionRequest = builder.build();
            this.completedToolCalls.add(toolExecutionRequest);
            this.completedToolCallItemIds.add(itemId);
            this.toolCallBuilders.remove(itemId);
            Integer index = this.toolCallIndices.remove(itemId);
            int n = safeIndex = index != null ? index : this.completedToolCalls.size() - 1;
            if (!this.isCancelled()) {
                InternalStreamingChatResponseHandlerUtils.onCompleteToolCall((StreamingChatResponseHandler)this.handler, (CompleteToolCall)new CompleteToolCall(safeIndex, toolExecutionRequest));
            }
        }
    }
}

