/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.openai;

import dev.ai4j.openai4j.chat.AssistantMessage;
import dev.ai4j.openai4j.chat.ChatCompletionChoice;
import dev.ai4j.openai4j.chat.ChatCompletionResponse;
import dev.ai4j.openai4j.chat.Function;
import dev.ai4j.openai4j.chat.FunctionCall;
import dev.ai4j.openai4j.chat.FunctionMessage;
import dev.ai4j.openai4j.chat.Message;
import dev.ai4j.openai4j.chat.Parameters;
import dev.ai4j.openai4j.chat.Role;
import dev.ai4j.openai4j.chat.Tool;
import dev.ai4j.openai4j.chat.ToolCall;
import dev.ai4j.openai4j.chat.ToolMessage;
import dev.ai4j.openai4j.chat.ToolType;
import dev.ai4j.openai4j.chat.UserMessage;
import dev.ai4j.openai4j.shared.Usage;
import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.agent.tool.ToolParameters;
import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.SystemMessage;
import dev.langchain4j.data.message.ToolExecutionResultMessage;
import dev.langchain4j.internal.Exceptions;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.output.FinishReason;
import dev.langchain4j.model.output.TokenUsage;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class InternalOpenAiHelper {
    static final String OPENAI_URL = "https://api.openai.com/v1";
    static final String OPENAI_DEMO_API_KEY = "demo";
    static final String OPENAI_DEMO_URL = "http://langchain4j.dev/demo/openai/v1";

    public static List<Message> toOpenAiMessages(List<ChatMessage> messages) {
        return messages.stream().map(InternalOpenAiHelper::toOpenAiMessage).collect(Collectors.toList());
    }

    public static Message toOpenAiMessage(ChatMessage message) {
        if (message instanceof SystemMessage) {
            return dev.ai4j.openai4j.chat.SystemMessage.from((String)message.text());
        }
        if (message instanceof dev.langchain4j.data.message.UserMessage) {
            dev.langchain4j.data.message.UserMessage userMessage = (dev.langchain4j.data.message.UserMessage)message;
            return UserMessage.builder().content(userMessage.text()).name(userMessage.name()).build();
        }
        if (message instanceof AiMessage) {
            AiMessage aiMessage = (AiMessage)message;
            if (!aiMessage.hasToolExecutionRequests()) {
                return AssistantMessage.from((String)message.text());
            }
            ToolExecutionRequest toolExecutionRequest = (ToolExecutionRequest)aiMessage.toolExecutionRequests().get(0);
            if (toolExecutionRequest.id() == null) {
                FunctionCall functionCall = FunctionCall.builder().name(toolExecutionRequest.name()).arguments(toolExecutionRequest.arguments()).build();
                return AssistantMessage.builder().functionCall(functionCall).build();
            }
            List toolCalls = aiMessage.toolExecutionRequests().stream().map(it -> ToolCall.builder().id(it.id()).type(ToolType.FUNCTION).function(FunctionCall.builder().name(it.name()).arguments(it.arguments()).build()).build()).collect(Collectors.toList());
            return AssistantMessage.builder().toolCalls(toolCalls).build();
        }
        if (message instanceof ToolExecutionResultMessage) {
            ToolExecutionResultMessage toolExecutionResultMessage = (ToolExecutionResultMessage)message;
            if (toolExecutionResultMessage.id() == null) {
                return FunctionMessage.from((String)toolExecutionResultMessage.toolName(), (String)toolExecutionResultMessage.text());
            }
            return ToolMessage.from((String)toolExecutionResultMessage.id(), (String)toolExecutionResultMessage.text());
        }
        throw Exceptions.illegalArgument((String)("Unknown message type: " + message.type()), (Object[])new Object[0]);
    }

    public static List<Tool> toTools(Collection<ToolSpecification> toolSpecifications) {
        return toolSpecifications.stream().map(InternalOpenAiHelper::toTool).collect(Collectors.toList());
    }

    private static Tool toTool(ToolSpecification toolSpecification) {
        Function function = Function.builder().name(toolSpecification.name()).description(toolSpecification.description()).parameters(InternalOpenAiHelper.toOpenAiParameters(toolSpecification.parameters())).build();
        return Tool.from((Function)function);
    }

    @Deprecated
    public static List<Function> toFunctions(Collection<ToolSpecification> toolSpecifications) {
        return toolSpecifications.stream().map(InternalOpenAiHelper::toFunction).collect(Collectors.toList());
    }

    @Deprecated
    private static Function toFunction(ToolSpecification toolSpecification) {
        return Function.builder().name(toolSpecification.name()).description(toolSpecification.description()).parameters(InternalOpenAiHelper.toOpenAiParameters(toolSpecification.parameters())).build();
    }

    private static Parameters toOpenAiParameters(ToolParameters toolParameters) {
        if (toolParameters == null) {
            return Parameters.builder().build();
        }
        return Parameters.builder().properties(toolParameters.properties()).required(toolParameters.required()).build();
    }

    public static AiMessage aiMessageFrom(ChatCompletionResponse response) {
        AssistantMessage assistantMessage = ((ChatCompletionChoice)response.choices().get(0)).message();
        List toolCalls = assistantMessage.toolCalls();
        if (!Utils.isNullOrEmpty((Collection)toolCalls)) {
            List toolExecutionRequests = toolCalls.stream().filter(toolCall -> toolCall.type() == ToolType.FUNCTION).map(InternalOpenAiHelper::toToolExecutionRequest).collect(Collectors.toList());
            return AiMessage.aiMessage(toolExecutionRequests);
        }
        FunctionCall functionCall = assistantMessage.functionCall();
        if (functionCall != null) {
            ToolExecutionRequest toolExecutionRequest = ToolExecutionRequest.builder().name(functionCall.name()).arguments(functionCall.arguments()).build();
            return AiMessage.aiMessage((ToolExecutionRequest[])new ToolExecutionRequest[]{toolExecutionRequest});
        }
        return AiMessage.aiMessage((String)assistantMessage.content());
    }

    private static ToolExecutionRequest toToolExecutionRequest(ToolCall toolCall) {
        FunctionCall functionCall = toolCall.function();
        return ToolExecutionRequest.builder().id(toolCall.id()).name(functionCall.name()).arguments(functionCall.arguments()).build();
    }

    public static TokenUsage tokenUsageFrom(Usage openAiUsage) {
        if (openAiUsage == null) {
            return null;
        }
        return new TokenUsage(openAiUsage.promptTokens(), openAiUsage.completionTokens(), openAiUsage.totalTokens());
    }

    public static FinishReason finishReasonFrom(String openAiFinishReason) {
        if (openAiFinishReason == null) {
            return null;
        }
        switch (openAiFinishReason) {
            case "stop": {
                return FinishReason.STOP;
            }
            case "length": {
                return FinishReason.LENGTH;
            }
            case "tool_calls": 
            case "function_call": {
                return FinishReason.TOOL_EXECUTION;
            }
            case "content_filter": {
                return FinishReason.CONTENT_FILTER;
            }
        }
        return null;
    }

    public static Role roleFrom(ChatMessage message) {
        if (message instanceof AiMessage) {
            return Role.ASSISTANT;
        }
        if (message instanceof ToolExecutionResultMessage) {
            return Role.FUNCTION;
        }
        if (message instanceof SystemMessage) {
            return Role.SYSTEM;
        }
        return Role.USER;
    }
}

