/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.rag.content.retriever.neo4j;

import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.chat.ChatLanguageModel;
import dev.langchain4j.model.input.Prompt;
import dev.langchain4j.model.input.PromptTemplate;
import dev.langchain4j.rag.content.Content;
import dev.langchain4j.rag.content.retriever.ContentRetriever;
import dev.langchain4j.rag.query.Query;
import dev.langchain4j.store.graph.neo4j.Neo4jGraph;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.neo4j.driver.Record;
import org.neo4j.driver.internal.value.NodeValue;

public class Neo4jContentRetriever
implements ContentRetriever {
    private static final PromptTemplate DEFAULT_PROMPT_TEMPLATE = PromptTemplate.from((String)"Based on the Neo4j graph schema below, write a Cypher query that would answer the user's question:\n{{schema}}\n\nQuestion: {{question}}\nCypher query:\n");
    private static final Pattern BACKTICKS_PATTERN = Pattern.compile("```(.*?)```", 40);
    private final Neo4jGraph graph;
    private final ChatLanguageModel chatLanguageModel;
    private final PromptTemplate promptTemplate;

    public Neo4jContentRetriever(Neo4jGraph graph, ChatLanguageModel chatLanguageModel, PromptTemplate promptTemplate) {
        this.graph = (Neo4jGraph)ValidationUtils.ensureNotNull((Object)graph, (String)"graph");
        this.chatLanguageModel = (ChatLanguageModel)ValidationUtils.ensureNotNull((Object)chatLanguageModel, (String)"chatLanguageModel");
        this.promptTemplate = (PromptTemplate)Utils.getOrDefault((Object)promptTemplate, (Object)DEFAULT_PROMPT_TEMPLATE);
    }

    public List<Content> retrieve(Query query) {
        String question = query.text();
        String schema = this.graph.getSchema();
        String cypherQuery = this.generateCypherQuery(schema, question);
        List<String> response = this.executeQuery(cypherQuery);
        return response.stream().map(Content::from).toList();
    }

    private String generateCypherQuery(String schema, String question) {
        Prompt cypherPrompt = this.promptTemplate.apply(Map.of("schema", schema, "question", question));
        String cypherQuery = this.chatLanguageModel.generate(cypherPrompt.text());
        Matcher matcher = BACKTICKS_PATTERN.matcher(cypherQuery);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return cypherQuery;
    }

    private List<String> executeQuery(String cypherQuery) {
        List<Record> records = this.graph.executeRead(cypherQuery);
        return records.stream().flatMap(r -> r.values().stream()).map(value -> value instanceof NodeValue ? value.asMap().toString() : value.toString()).toList();
    }

    public static Neo4jContentRetrieverBuilder builder() {
        return new Neo4jContentRetrieverBuilder();
    }

    public static class Neo4jContentRetrieverBuilder {
        private Neo4jGraph graph;
        private ChatLanguageModel chatLanguageModel;
        private PromptTemplate promptTemplate;

        Neo4jContentRetrieverBuilder() {
        }

        public Neo4jContentRetrieverBuilder graph(Neo4jGraph graph) {
            this.graph = graph;
            return this;
        }

        public Neo4jContentRetrieverBuilder chatLanguageModel(ChatLanguageModel chatLanguageModel) {
            this.chatLanguageModel = chatLanguageModel;
            return this;
        }

        public Neo4jContentRetrieverBuilder promptTemplate(PromptTemplate promptTemplate) {
            this.promptTemplate = promptTemplate;
            return this;
        }

        public Neo4jContentRetriever build() {
            return new Neo4jContentRetriever(this.graph, this.chatLanguageModel, this.promptTemplate);
        }

        public String toString() {
            return "Neo4jContentRetriever.Neo4jContentRetrieverBuilder(graph=" + String.valueOf(this.graph) + ", chatLanguageModel=" + String.valueOf(this.chatLanguageModel) + ", promptTemplate=" + String.valueOf(this.promptTemplate) + ")";
        }
    }
}

