/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.mistralai.internal.client;

import dev.langchain4j.Internal;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.http.client.HttpClient;
import dev.langchain4j.http.client.HttpClientBuilder;
import dev.langchain4j.http.client.HttpClientBuilderLoader;
import dev.langchain4j.http.client.HttpMethod;
import dev.langchain4j.http.client.HttpRequest;
import dev.langchain4j.http.client.SuccessfulHttpResponse;
import dev.langchain4j.http.client.log.LoggingHttpClient;
import dev.langchain4j.http.client.sse.ServerSentEventListener;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.StreamingResponseHandler;
import dev.langchain4j.model.chat.response.StreamingChatResponseHandler;
import dev.langchain4j.model.mistralai.internal.api.MistralAiChatCompletionRequest;
import dev.langchain4j.model.mistralai.internal.api.MistralAiChatCompletionResponse;
import dev.langchain4j.model.mistralai.internal.api.MistralAiEmbeddingRequest;
import dev.langchain4j.model.mistralai.internal.api.MistralAiEmbeddingResponse;
import dev.langchain4j.model.mistralai.internal.api.MistralAiFimCompletionRequest;
import dev.langchain4j.model.mistralai.internal.api.MistralAiModelResponse;
import dev.langchain4j.model.mistralai.internal.api.MistralAiModerationRequest;
import dev.langchain4j.model.mistralai.internal.api.MistralAiModerationResponse;
import dev.langchain4j.model.mistralai.internal.client.MistralAiClient;
import dev.langchain4j.model.mistralai.internal.client.MistralAiFimServerSentEventListener;
import dev.langchain4j.model.mistralai.internal.client.MistralAiJsonUtils;
import dev.langchain4j.model.mistralai.internal.client.MistralAiServerSentEventListener;
import java.time.Duration;
import java.util.Collection;
import java.util.List;

@Internal
public class DefaultMistralAiClient
extends MistralAiClient {
    private final HttpClient httpClient;
    private final String baseUrl;
    private final String apiKey;

    public static Builder builder() {
        return new Builder();
    }

    DefaultMistralAiClient(Builder builder) {
        HttpClientBuilder httpClientBuilder = (HttpClientBuilder)Utils.getOrDefault((Object)builder.httpClientBuilder, HttpClientBuilderLoader::loadHttpClientBuilder);
        HttpClient httpClient = httpClientBuilder.connectTimeout((Duration)Utils.getOrDefault((Object)((Duration)Utils.getOrDefault((Object)builder.timeout, (Object)httpClientBuilder.connectTimeout())), (Object)Duration.ofSeconds(15L))).readTimeout((Duration)Utils.getOrDefault((Object)((Duration)Utils.getOrDefault((Object)builder.timeout, (Object)httpClientBuilder.readTimeout())), (Object)Duration.ofSeconds(60L))).build();
        this.httpClient = builder.logRequests != null && builder.logRequests != false || builder.logResponses != null && builder.logResponses != false ? new LoggingHttpClient(httpClient, builder.logRequests, builder.logResponses, builder.logger) : httpClient;
        this.baseUrl = ValidationUtils.ensureNotBlank((String)builder.baseUrl, (String)"baseUrl");
        this.apiKey = ValidationUtils.ensureNotBlank((String)builder.apiKey, (String)"apiKey");
    }

    @Override
    public MistralAiChatCompletionResponse chatCompletion(MistralAiChatCompletionRequest request) {
        HttpRequest httpRequest = HttpRequest.builder().method(HttpMethod.POST).url(this.baseUrl, "chat/completions").addHeader("Authorization", new String[]{"Bearer " + this.apiKey}).addHeader("Content-Type", new String[]{"application/json"}).addHeader("User-Agent", new String[]{"langchain4j-mistral-ai"}).body(MistralAiJsonUtils.toJson(request)).build();
        SuccessfulHttpResponse successfulHttpResponse = this.httpClient.execute(httpRequest);
        return MistralAiJsonUtils.fromJson(successfulHttpResponse.body(), MistralAiChatCompletionResponse.class);
    }

    @Override
    public void streamingChatCompletion(MistralAiChatCompletionRequest request, StreamingChatResponseHandler handler) {
        ValidationUtils.ensureNotEmpty(request.getMessages(), (String)"messages");
        HttpRequest httpRequest = HttpRequest.builder().method(HttpMethod.POST).url(this.baseUrl, "chat/completions").addHeader("Authorization", new String[]{"Bearer " + this.apiKey}).addHeader("Content-Type", new String[]{"application/json"}).addHeader("User-Agent", new String[]{"langchain4j-mistral-ai"}).body(MistralAiJsonUtils.toJson(request)).build();
        MistralAiServerSentEventListener listener = new MistralAiServerSentEventListener(handler, (content, toolExecutionRequests) -> {
            if (!Utils.isNullOrEmpty((Collection)toolExecutionRequests)) {
                return AiMessage.from((List)toolExecutionRequests);
            }
            return AiMessage.from((String)content);
        });
        this.httpClient.execute(httpRequest, (ServerSentEventListener)listener);
    }

    @Override
    public MistralAiChatCompletionResponse fimCompletion(MistralAiFimCompletionRequest request) {
        HttpRequest httpRequest = HttpRequest.builder().method(HttpMethod.POST).url(this.baseUrl, "fim/completions").addHeader("Authorization", new String[]{"Bearer " + this.apiKey}).addHeader("Content-Type", new String[]{"application/json"}).addHeader("User-Agent", new String[]{"langchain4j-mistral-ai"}).body(MistralAiJsonUtils.toJson(request)).build();
        SuccessfulHttpResponse successfulHttpResponse = this.httpClient.execute(httpRequest);
        return MistralAiJsonUtils.fromJson(successfulHttpResponse.body(), MistralAiChatCompletionResponse.class);
    }

    @Override
    public void streamingFimCompletion(MistralAiFimCompletionRequest request, StreamingResponseHandler<String> handler) {
        HttpRequest httpRequest = HttpRequest.builder().method(HttpMethod.POST).url(this.baseUrl, "fim/completions").addHeader("Authorization", new String[]{"Bearer " + this.apiKey}).addHeader("Content-Type", new String[]{"application/json"}).addHeader("User-Agent", new String[]{"langchain4j-mistral-ai"}).body(MistralAiJsonUtils.toJson(request)).build();
        MistralAiFimServerSentEventListener listener = new MistralAiFimServerSentEventListener(handler, (content, toolExecutionRequests) -> content);
        this.httpClient.execute(httpRequest, (ServerSentEventListener)listener);
    }

    @Override
    public MistralAiEmbeddingResponse embedding(MistralAiEmbeddingRequest request) {
        HttpRequest httpRequest = HttpRequest.builder().method(HttpMethod.POST).url(this.baseUrl, "embeddings").addHeader("Authorization", new String[]{"Bearer " + this.apiKey}).addHeader("Content-Type", new String[]{"application/json"}).addHeader("User-Agent", new String[]{"langchain4j-mistral-ai"}).body(MistralAiJsonUtils.toJson(request)).build();
        SuccessfulHttpResponse successfulHttpResponse = this.httpClient.execute(httpRequest);
        return MistralAiJsonUtils.fromJson(successfulHttpResponse.body(), MistralAiEmbeddingResponse.class);
    }

    @Override
    public MistralAiModerationResponse moderation(MistralAiModerationRequest request) {
        HttpRequest httpRequest = HttpRequest.builder().method(HttpMethod.POST).url(this.baseUrl, "moderations").addHeader("Authorization", new String[]{"Bearer " + this.apiKey}).addHeader("Content-Type", new String[]{"application/json"}).addHeader("User-Agent", new String[]{"langchain4j-mistral-ai"}).body(MistralAiJsonUtils.toJson(request)).build();
        SuccessfulHttpResponse successfulHttpResponse = this.httpClient.execute(httpRequest);
        return MistralAiJsonUtils.fromJson(successfulHttpResponse.body(), MistralAiModerationResponse.class);
    }

    @Override
    public MistralAiModelResponse listModels() {
        HttpRequest httpRequest = HttpRequest.builder().method(HttpMethod.GET).url(this.baseUrl, "models").addHeader("Authorization", new String[]{"Bearer " + this.apiKey}).addHeader("Content-Type", new String[]{"application/json"}).addHeader("User-Agent", new String[]{"langchain4j-mistral-ai"}).build();
        SuccessfulHttpResponse successfulHttpResponse = this.httpClient.execute(httpRequest);
        return MistralAiJsonUtils.fromJson(successfulHttpResponse.body(), MistralAiModelResponse.class);
    }

    public static class Builder
    extends MistralAiClient.Builder<DefaultMistralAiClient, Builder> {
        @Override
        public DefaultMistralAiClient build() {
            return new DefaultMistralAiClient(this);
        }
    }
}

