/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.jlama;

import com.github.tjake.jlama.model.AbstractModel;
import com.github.tjake.jlama.model.functions.Generator;
import com.github.tjake.jlama.safetensors.tokenizer.PromptSupport;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.internal.RetryUtils;
import dev.langchain4j.model.chat.ChatLanguageModel;
import dev.langchain4j.model.jlama.JlamaLanguageModel;
import dev.langchain4j.model.jlama.JlamaModel;
import dev.langchain4j.model.jlama.JlamaModelRegistry;
import dev.langchain4j.model.jlama.spi.JlamaChatModelBuilderFactory;
import dev.langchain4j.model.output.FinishReason;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.output.TokenUsage;
import dev.langchain4j.spi.ServiceHelper;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;

public class JlamaChatModel
implements ChatLanguageModel {
    private final AbstractModel model;
    private final Float temperature;
    private final Integer maxTokens;
    private final UUID id = UUID.randomUUID();

    public JlamaChatModel(Path modelCachePath, String modelName, String authToken, Integer threadCount, Boolean quantizeModelAtRuntime, Path workingDirectory, Float temperature, Integer maxTokens) {
        JlamaModelRegistry registry = JlamaModelRegistry.getOrCreate(modelCachePath);
        JlamaModel jlamaModel = (JlamaModel)RetryUtils.withRetry(() -> registry.downloadModel(modelName, Optional.ofNullable(authToken)), (int)3);
        JlamaModel.Loader loader = jlamaModel.loader();
        if (quantizeModelAtRuntime != null && quantizeModelAtRuntime.booleanValue()) {
            loader = loader.quantized();
        }
        if (threadCount != null) {
            loader = loader.threadCount(threadCount);
        }
        if (workingDirectory != null) {
            loader = loader.workingDirectory(workingDirectory);
        }
        this.model = loader.load();
        this.temperature = Float.valueOf(temperature == null ? 0.7f : temperature.floatValue());
        this.maxTokens = maxTokens == null ? this.model.getConfig().contextLength : maxTokens;
    }

    public static JlamaChatModelBuilder builder() {
        Iterator iterator = ServiceHelper.loadFactories(JlamaChatModelBuilderFactory.class).iterator();
        if (iterator.hasNext()) {
            JlamaChatModelBuilderFactory factory = (JlamaChatModelBuilderFactory)iterator.next();
            return (JlamaChatModelBuilder)factory.get();
        }
        return new JlamaChatModelBuilder();
    }

    public Response<AiMessage> generate(List<ChatMessage> messages) {
        if (this.model.promptSupport().isEmpty()) {
            throw new UnsupportedOperationException("This model does not support chat generation");
        }
        PromptSupport.Builder promptBuilder = ((PromptSupport)this.model.promptSupport().get()).newBuilder();
        block5: for (ChatMessage message : messages) {
            switch (message.type()) {
                case SYSTEM: {
                    promptBuilder.addSystemMessage(message.text());
                    continue block5;
                }
                case USER: {
                    promptBuilder.addUserMessage(message.text());
                    continue block5;
                }
                case AI: {
                    promptBuilder.addAssistantMessage(message.text());
                    continue block5;
                }
            }
            throw new IllegalArgumentException("Unsupported message type: " + String.valueOf(message.type()));
        }
        Generator.Response r = this.model.generate(this.id, promptBuilder.build(), this.temperature.floatValue(), this.maxTokens.intValue(), false, (token, time) -> {});
        return Response.from((Object)AiMessage.from((String)r.text), (TokenUsage)new TokenUsage(Integer.valueOf(r.promptTokens), Integer.valueOf(r.generatedTokens)), (FinishReason)JlamaLanguageModel.toFinishReason(r.finishReason));
    }

    public static class JlamaChatModelBuilder {
        private Path modelCachePath;
        private String modelName;
        private String authToken;
        private Integer threadCount;
        private Boolean quantizeModelAtRuntime;
        private Path workingDirectory;
        private Float temperature;
        private Integer maxTokens;

        public JlamaChatModelBuilder modelCachePath(Path modelCachePath) {
            this.modelCachePath = modelCachePath;
            return this;
        }

        public JlamaChatModelBuilder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public JlamaChatModelBuilder authToken(String authToken) {
            this.authToken = authToken;
            return this;
        }

        public JlamaChatModelBuilder threadCount(Integer threadCount) {
            this.threadCount = threadCount;
            return this;
        }

        public JlamaChatModelBuilder quantizeModelAtRuntime(Boolean quantizeModelAtRuntime) {
            this.quantizeModelAtRuntime = quantizeModelAtRuntime;
            return this;
        }

        public JlamaChatModelBuilder workingDirectory(Path workingDirectory) {
            this.workingDirectory = workingDirectory;
            return this;
        }

        public JlamaChatModelBuilder temperature(Float temperature) {
            this.temperature = temperature;
            return this;
        }

        public JlamaChatModelBuilder maxTokens(Integer maxTokens) {
            this.maxTokens = maxTokens;
            return this;
        }

        public JlamaChatModel build() {
            return new JlamaChatModel(this.modelCachePath, this.modelName, this.authToken, this.threadCount, this.quantizeModelAtRuntime, this.workingDirectory, this.temperature, this.maxTokens);
        }

        public String toString() {
            return "JlamaChatModel.JlamaChatModelBuilder(modelCachePath=" + String.valueOf(this.modelCachePath) + ", modelName=" + this.modelName + ", authToken=" + this.authToken + ", threadCount=" + this.threadCount + ", quantizeModelAtRuntime=" + this.quantizeModelAtRuntime + ", workingDirectory=" + String.valueOf(this.workingDirectory) + ", temperature=" + this.temperature + ", maxTokens=" + this.maxTokens + ")";
        }
    }
}

