/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.store.embedding.infinispan;

import dev.langchain4j.store.embedding.infinispan.LangChainInfinispanItem;
import dev.langchain4j.store.embedding.infinispan.LangChainMetadata;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.infinispan.protostream.MessageMarshaller;

public class LangChainItemMarshaller
implements MessageMarshaller<LangChainInfinispanItem> {
    private final String typeName;

    public LangChainItemMarshaller(String typeName) {
        this.typeName = typeName;
    }

    public LangChainInfinispanItem readFrom(MessageMarshaller.ProtoStreamReader reader) throws IOException {
        String id = reader.readString("id");
        float[] embedding = reader.readFloats("embedding");
        String text = reader.readString("text");
        Set metadata = (Set)reader.readCollection("metadata", new HashSet(), LangChainMetadata.class);
        return new LangChainInfinispanItem(id, embedding, text, metadata);
    }

    public void writeTo(MessageMarshaller.ProtoStreamWriter writer, LangChainInfinispanItem item) throws IOException {
        writer.writeString("id", item.id());
        writer.writeFloats("embedding", item.embedding());
        writer.writeString("text", item.text());
        writer.writeCollection("metadata", item.metadata(), LangChainMetadata.class);
    }

    public Class<? extends LangChainInfinispanItem> getJavaClass() {
        return LangChainInfinispanItem.class;
    }

    public String getTypeName() {
        return this.typeName;
    }
}

