/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.http.client;

import dev.langchain4j.Internal;
import dev.langchain4j.http.client.HttpClient;
import dev.langchain4j.http.client.HttpRequest;
import dev.langchain4j.http.client.SuccessfulHttpResponse;
import dev.langchain4j.http.client.sse.ServerSentEventListener;
import dev.langchain4j.http.client.sse.ServerSentEventParser;
import dev.langchain4j.internal.ValidationUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@Internal
public class SpyingHttpClient
implements HttpClient {
    private final HttpClient delegate;
    private final List<HttpRequest> requests = Collections.synchronizedList(new ArrayList());

    public SpyingHttpClient(HttpClient delegate) {
        this.delegate = (HttpClient)ValidationUtils.ensureNotNull((Object)delegate, (String)"delegate");
    }

    public List<HttpRequest> requests() {
        return this.requests;
    }

    public HttpRequest request() {
        if (this.requests.size() != 1) {
            throw new IllegalStateException("Expected 1 request, but got: " + this.requests.size());
        }
        return this.requests.get(0);
    }

    public SuccessfulHttpResponse execute(HttpRequest request) {
        this.requests.add(request);
        return this.delegate.execute(request);
    }

    public void execute(HttpRequest request, ServerSentEventParser parser, ServerSentEventListener listener) {
        this.requests.add(request);
        this.delegate.execute(request, parser, listener);
    }
}

