/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.googleai;

import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.model.googleai.FinishReasonMapper;
import dev.langchain4j.model.googleai.GeminiCandidate;
import dev.langchain4j.model.googleai.GeminiContent;
import dev.langchain4j.model.googleai.GeminiGenerateContentResponse;
import dev.langchain4j.model.googleai.GeminiUsageMetadata;
import dev.langchain4j.model.googleai.PartsAndContentsMapper;
import dev.langchain4j.model.output.FinishReason;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.output.TokenUsage;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

class GeminiStreamingResponseBuilder {
    private final boolean includeCodeExecutionOutput;
    private final StringBuilder contentBuilder;
    private final List<ToolExecutionRequest> functionCalls;
    private TokenUsage tokenUsage;
    private FinishReason finishReason;

    public GeminiStreamingResponseBuilder(boolean includeCodeExecutionOutput) {
        this.includeCodeExecutionOutput = includeCodeExecutionOutput;
        this.contentBuilder = new StringBuilder();
        this.functionCalls = new ArrayList<ToolExecutionRequest>();
    }

    public Optional<String> append(GeminiGenerateContentResponse partialResponse) {
        if (partialResponse == null) {
            return Optional.empty();
        }
        GeminiCandidate firstCandidate = partialResponse.getCandidates().get(0);
        this.updateFinishReason(firstCandidate);
        this.updateTokenUsage(partialResponse.getUsageMetadata());
        GeminiContent content = firstCandidate.getContent();
        if (content == null || content.getParts() == null) {
            return Optional.empty();
        }
        AiMessage message = PartsAndContentsMapper.fromGPartsToAiMessage(content.getParts(), this.includeCodeExecutionOutput);
        this.updateContentAndFunctionCalls(message);
        return Optional.ofNullable(message.text());
    }

    public Response<AiMessage> build() {
        AiMessage aiMessage = this.createAiMessage();
        return Response.from((Object)aiMessage, (TokenUsage)this.tokenUsage, (FinishReason)this.finishReason);
    }

    private void updateTokenUsage(GeminiUsageMetadata tokenCounts) {
        this.tokenUsage = new TokenUsage(tokenCounts.getPromptTokenCount(), tokenCounts.getCandidatesTokenCount(), tokenCounts.getTotalTokenCount());
    }

    private void updateFinishReason(GeminiCandidate candidate) {
        if (candidate.getFinishReason() != null) {
            this.finishReason = FinishReasonMapper.fromGFinishReasonToFinishReason(candidate.getFinishReason());
        }
    }

    private void updateContentAndFunctionCalls(AiMessage message) {
        Optional.ofNullable(message.text()).ifPresent(this.contentBuilder::append);
        if (message.hasToolExecutionRequests()) {
            this.functionCalls.addAll(message.toolExecutionRequests());
        }
    }

    private AiMessage createAiMessage() {
        boolean hasFunctionCall;
        String text = this.contentBuilder.toString();
        boolean hasText = !text.isEmpty() && !text.isBlank();
        boolean bl = hasFunctionCall = !this.functionCalls.isEmpty();
        if (hasText && hasFunctionCall) {
            return new AiMessage(text, this.functionCalls);
        }
        if (hasText) {
            return new AiMessage(text);
        }
        if (hasFunctionCall) {
            return new AiMessage(this.functionCalls);
        }
        throw new RuntimeException("Gemini has responded neither with text nor with a function call.");
    }
}

