/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.rag.query.router;

import dev.langchain4j.rag.content.retriever.ContentRetriever;
import dev.langchain4j.rag.query.Query;
import dev.langchain4j.rag.query.router.DefaultQueryRouter;
import java.util.Arrays;
import java.util.Collection;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.AssertionsForClassTypes;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class DefaultQueryRouterTest {
    DefaultQueryRouterTest() {
    }

    @Test
    void should_route_to_single_retriever() {
        ContentRetriever retriever1 = (ContentRetriever)Mockito.mock(ContentRetriever.class);
        DefaultQueryRouter router = new DefaultQueryRouter(new ContentRetriever[]{retriever1});
        Collection retrievers = router.route(Query.from((String)"query"));
        Assertions.assertThat((Collection)retrievers).containsExactly((Object[])new ContentRetriever[]{retriever1});
    }

    @Test
    void should_route_to_multiple_retrievers() {
        ContentRetriever retriever1 = (ContentRetriever)Mockito.mock(ContentRetriever.class);
        ContentRetriever retriever2 = (ContentRetriever)Mockito.mock(ContentRetriever.class);
        DefaultQueryRouter router = new DefaultQueryRouter(Arrays.asList(retriever1, retriever2));
        Collection retrievers = router.route(Query.from((String)"query"));
        Assertions.assertThat((Collection)retrievers).containsExactly((Object[])new ContentRetriever[]{retriever1, retriever2});
    }

    @Test
    void should_route_to_multiple_retrievers_varargs() {
        ContentRetriever retriever1 = (ContentRetriever)Mockito.mock(ContentRetriever.class);
        ContentRetriever retriever2 = (ContentRetriever)Mockito.mock(ContentRetriever.class);
        DefaultQueryRouter router = new DefaultQueryRouter(new ContentRetriever[]{retriever1, retriever2});
        Collection retrievers = router.route(Query.from((String)"query"));
        Assertions.assertThat((Collection)retrievers).containsExactly((Object[])new ContentRetriever[]{retriever1, retriever2});
    }

    @Test
    void should_handle_empty_retrievers_list() {
        ((AbstractThrowableAssert)AssertionsForClassTypes.assertThatThrownBy(() -> new DefaultQueryRouter(Arrays.asList(new ContentRetriever[0]))).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("contentRetrievers cannot be null or empty");
    }

    @Test
    void should_handle_null_retrievers_list() {
        ((AbstractThrowableAssert)AssertionsForClassTypes.assertThatThrownBy(() -> new DefaultQueryRouter((Collection)null)).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("contentRetrievers cannot be null or empty");
    }

    @Test
    void should_preserve_retriever_order() {
        ContentRetriever retriever1 = (ContentRetriever)Mockito.mock(ContentRetriever.class);
        ContentRetriever retriever2 = (ContentRetriever)Mockito.mock(ContentRetriever.class);
        ContentRetriever retriever3 = (ContentRetriever)Mockito.mock(ContentRetriever.class);
        DefaultQueryRouter router = new DefaultQueryRouter(new ContentRetriever[]{retriever1, retriever2, retriever3});
        Collection retrievers = router.route(Query.from((String)"query"));
        Assertions.assertThat((Collection)retrievers).containsExactly((Object[])new ContentRetriever[]{retriever1, retriever2, retriever3});
    }

    @Test
    void should_handle_duplicate_retrievers() {
        ContentRetriever retriever = (ContentRetriever)Mockito.mock(ContentRetriever.class);
        DefaultQueryRouter router = new DefaultQueryRouter(new ContentRetriever[]{retriever, retriever, retriever});
        Collection retrievers = router.route(Query.from((String)"query"));
        Assertions.assertThat((Collection)retrievers).hasSize(3);
        Assertions.assertThat((Collection)retrievers).containsExactly((Object[])new ContentRetriever[]{retriever, retriever, retriever});
    }

    @Test
    void should_handle_empty_query_text() {
        ((AbstractThrowableAssert)AssertionsForClassTypes.assertThatThrownBy(() -> Query.from((String)"")).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("text cannot be null or blank");
    }

    @Test
    void should_handle_null_query() {
        ContentRetriever retriever = (ContentRetriever)Mockito.mock(ContentRetriever.class);
        DefaultQueryRouter router = new DefaultQueryRouter(new ContentRetriever[]{retriever});
        Collection retrievers = router.route(null);
        Assertions.assertThat((Collection)retrievers).containsExactly((Object[])new ContentRetriever[]{retriever});
    }
}

