/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.observability.api;

import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.guardrail.ChatExecutor;
import dev.langchain4j.guardrail.GuardrailRequest;
import dev.langchain4j.guardrail.GuardrailRequestParams;
import dev.langchain4j.guardrail.GuardrailResult;
import dev.langchain4j.guardrail.InputGuardrail;
import dev.langchain4j.guardrail.InputGuardrailRequest;
import dev.langchain4j.guardrail.InputGuardrailResult;
import dev.langchain4j.guardrail.OutputGuardrail;
import dev.langchain4j.guardrail.OutputGuardrailRequest;
import dev.langchain4j.guardrail.OutputGuardrailResult;
import dev.langchain4j.invocation.InvocationContext;
import dev.langchain4j.model.chat.response.ChatResponse;
import dev.langchain4j.observability.api.AiServiceListenerRegistrar;
import dev.langchain4j.observability.api.DefaultAiServiceListenerRegistrar;
import dev.langchain4j.observability.api.event.AiServiceCompletedEvent;
import dev.langchain4j.observability.api.event.AiServiceErrorEvent;
import dev.langchain4j.observability.api.event.AiServiceEvent;
import dev.langchain4j.observability.api.event.AiServiceResponseReceivedEvent;
import dev.langchain4j.observability.api.event.AiServiceStartedEvent;
import dev.langchain4j.observability.api.event.InputGuardrailExecutedEvent;
import dev.langchain4j.observability.api.event.OutputGuardrailExecutedEvent;
import dev.langchain4j.observability.api.event.ToolExecutedEvent;
import dev.langchain4j.observability.api.listener.AiServiceCompletedListener;
import dev.langchain4j.observability.api.listener.AiServiceErrorListener;
import dev.langchain4j.observability.api.listener.AiServiceListener;
import dev.langchain4j.observability.api.listener.AiServiceResponseReceivedListener;
import dev.langchain4j.observability.api.listener.AiServiceStartedListener;
import dev.langchain4j.observability.api.listener.InputGuardrailExecutedListener;
import dev.langchain4j.observability.api.listener.OutputGuardrailExecutedListener;
import dev.langchain4j.observability.api.listener.ToolExecutedEventListener;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.IntStream;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.ThrowingConsumer;
import org.junit.jupiter.api.Test;

class DefaultAiServiceListenerRegistrarTests {
    private static final AiServiceListenerRegistrar REGISTRAR = AiServiceListenerRegistrar.newInstance();
    private static final InvocationContext DEFAULT_INVOCATION_CONTEXT = InvocationContext.builder().interfaceName("SomeInterface").methodName("someMethod").methodArgument((Object)"one").methodArgument((Object)"two").chatMemoryId((Object)"one").build();
    private static final AiServiceResponseReceivedEvent RESPONSE_RECEIVED_EVENT = AiServiceResponseReceivedEvent.builder().invocationContext(DEFAULT_INVOCATION_CONTEXT).response(ChatResponse.builder().aiMessage(AiMessage.from((String)"Message!")).build()).build();
    private static final AiServiceErrorEvent INVOCATION_ERROR_EVENT = AiServiceErrorEvent.builder().invocationContext(DEFAULT_INVOCATION_CONTEXT).error((Throwable)new RuntimeException("Some error")).build();
    private static final AiServiceCompletedEvent INVOCATION_COMPLETED_EVENT = AiServiceCompletedEvent.builder().invocationContext(DEFAULT_INVOCATION_CONTEXT).build();
    private static final AiServiceStartedEvent INVOCATION_STARTED_EVENT = AiServiceStartedEvent.builder().invocationContext(DEFAULT_INVOCATION_CONTEXT).userMessage(UserMessage.from((String)"Hello, world!")).build();
    private static final OutputGuardrailExecutedEvent OUTPUT_GUARDRAIL_EXECUTED_EVENT = (OutputGuardrailExecutedEvent)OutputGuardrailExecutedEvent.builder().invocationContext(DEFAULT_INVOCATION_CONTEXT).guardrailClass(OG.class).request((GuardrailRequest)OutputGuardrailRequest.builder().responseFromLLM(ChatResponse.builder().aiMessage(AiMessage.from((String)"Message!")).build()).requestParams(GuardrailRequestParams.builder().userMessageTemplate("").variables(Map.of()).invocationContext(DEFAULT_INVOCATION_CONTEXT).aiServiceListenerRegistrar(REGISTRAR).build()).chatExecutor(new ChatExecutor(){

        public ChatResponse execute() {
            return this.execute(List.of());
        }

        public ChatResponse execute(List<ChatMessage> chatMessages) {
            return ChatResponse.builder().aiMessage(AiMessage.from((String)"Message!")).build();
        }
    }).build()).result((GuardrailResult)OutputGuardrailResult.success()).build();
    private static final InputGuardrailExecutedEvent INPUT_GUARDRAIL_EXECUTED_EVENT = (InputGuardrailExecutedEvent)InputGuardrailExecutedEvent.builder().invocationContext(DEFAULT_INVOCATION_CONTEXT).guardrailClass(IG.class).request((GuardrailRequest)InputGuardrailRequest.builder().userMessage(UserMessage.from((String)"Hello, world!")).commonParams(GuardrailRequestParams.builder().userMessageTemplate("").variables(Map.of()).invocationContext(DEFAULT_INVOCATION_CONTEXT).aiServiceListenerRegistrar(REGISTRAR).build()).build()).result((GuardrailResult)InputGuardrailResult.success()).build();
    private static final ToolExecutedEvent TOOL_EXECUTED_EVENT = ToolExecutedEvent.builder().invocationContext(DEFAULT_INVOCATION_CONTEXT).request(ToolExecutionRequest.builder().build()).resultText("Success!").build();
    private static final List<AiServiceEvent> ALL_EVENTS = List.of(RESPONSE_RECEIVED_EVENT, INVOCATION_ERROR_EVENT, INVOCATION_COMPLETED_EVENT, INVOCATION_STARTED_EVENT, OUTPUT_GUARDRAIL_EXECUTED_EVENT, INPUT_GUARDRAIL_EXECUTED_EVENT, TOOL_EXECUTED_EVENT);
    private static final List<AbstractTestEventListener<?>> ALL_LISTENERS = IntStream.range(0, 2).mapToObj(i -> List.of(new TestInputGuardrailListener(), new TestOutputGuardrailListener(), new TestInvocationStartedListener(), new TestInvocationCompletedListener(), new TestInvocationErrorListener(), new TestLLMResponseReceivedListener(), new TestToolExecutedListener())).flatMap(Collection::stream).toList();

    DefaultAiServiceListenerRegistrarTests() {
    }

    @Test
    void hasCorrectListeners() {
        DefaultAiServiceListenerRegistrar registrar = (DefaultAiServiceListenerRegistrar)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)REGISTRAR).isNotNull()).isExactlyInstanceOf(DefaultAiServiceListenerRegistrar.class)).actual();
        DefaultAiServiceListenerRegistrarTests.assertListenersNotExecuted();
        ALL_LISTENERS.forEach(arg_0 -> ((DefaultAiServiceListenerRegistrar)registrar).register(arg_0));
        ALL_EVENTS.forEach(arg_0 -> ((DefaultAiServiceListenerRegistrar)registrar).fireEvent(arg_0));
        Assertions.assertThat(ALL_LISTENERS).allSatisfy(l -> ((ObjectAssert)Assertions.assertThat((Object)l).isNotNull()).satisfies(new ThrowingConsumer[]{el -> Assertions.assertThat((int)el.count()).isOne(), el -> ((ObjectAssert)Assertions.assertThat(el.lastEvent()).isNotNull()).extracting(AiServiceEvent::invocationContext).usingRecursiveComparison().isEqualTo((Object)DEFAULT_INVOCATION_CONTEXT)}));
        ALL_LISTENERS.forEach(l -> {
            registrar.unregister((AiServiceListener)l);
            l.reset();
        });
        ALL_EVENTS.forEach(arg_0 -> ((DefaultAiServiceListenerRegistrar)registrar).fireEvent(arg_0));
        DefaultAiServiceListenerRegistrarTests.assertListenersNotExecuted();
    }

    private static void assertListenersNotExecuted() {
        ((ListAssert)((ListAssert)Assertions.assertThat(ALL_LISTENERS).isNotNull()).hasSize(14)).allSatisfy(l -> ((ObjectAssert)Assertions.assertThat((Object)l).isNotNull()).satisfies(new ThrowingConsumer[]{el -> Assertions.assertThat((int)el.count()).isZero(), el -> Assertions.assertThat(el.lastEvent()).isNull()}));
    }

    private static abstract class AbstractTestEventListener<T extends AiServiceEvent>
    implements AiServiceListener<T> {
        private final AtomicInteger count = new AtomicInteger();
        private T lastEvent;

        private AbstractTestEventListener() {
        }

        public void onEvent(T event) {
            this.count.incrementAndGet();
            this.lastEvent = event;
        }

        int count() {
            return this.count.get();
        }

        T lastEvent() {
            return this.lastEvent;
        }

        void reset() {
            this.count.set(0);
            this.lastEvent = null;
        }
    }

    private static class TestInputGuardrailListener
    extends AbstractTestEventListener<InputGuardrailExecutedEvent>
    implements InputGuardrailExecutedListener {
        private TestInputGuardrailListener() {
        }
    }

    private static class TestOutputGuardrailListener
    extends AbstractTestEventListener<OutputGuardrailExecutedEvent>
    implements OutputGuardrailExecutedListener {
        private TestOutputGuardrailListener() {
        }
    }

    private static class TestInvocationStartedListener
    extends AbstractTestEventListener<AiServiceStartedEvent>
    implements AiServiceStartedListener {
        private TestInvocationStartedListener() {
        }
    }

    private static class TestInvocationCompletedListener
    extends AbstractTestEventListener<AiServiceCompletedEvent>
    implements AiServiceCompletedListener {
        private TestInvocationCompletedListener() {
        }
    }

    private static class TestInvocationErrorListener
    extends AbstractTestEventListener<AiServiceErrorEvent>
    implements AiServiceErrorListener {
        private TestInvocationErrorListener() {
        }
    }

    private static class TestLLMResponseReceivedListener
    extends AbstractTestEventListener<AiServiceResponseReceivedEvent>
    implements AiServiceResponseReceivedListener {
        private TestLLMResponseReceivedListener() {
        }
    }

    private static class TestToolExecutedListener
    extends AbstractTestEventListener<ToolExecutedEvent>
    implements ToolExecutedEventListener {
        private TestToolExecutedListener() {
        }
    }

    private static class OG
    implements OutputGuardrail {
        private OG() {
        }
    }

    private static class IG
    implements InputGuardrail {
        private IG() {
        }
    }
}

