/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.invocation;

import dev.langchain4j.invocation.InvocationParameters;
import java.util.HashMap;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class InvocationParametersTest {
    InvocationParametersTest() {
    }

    @Test
    void test1() {
        InvocationParameters invocationParameters = new InvocationParameters();
        invocationParameters.put("key", (Object)"value");
        String value = (String)invocationParameters.get("key");
        Assertions.assertThat((Object)value).isEqualTo((Object)"value");
    }

    @Test
    void test2() {
        InvocationParameters invocationParameters = InvocationParameters.from((String)"key", (Object)"value");
        Assertions.assertThat((Map)invocationParameters.asMap()).containsOnly(new Map.Entry[]{Map.entry("key", "value")});
    }

    @Test
    void test3() {
        InvocationParameters invocationParameters = InvocationParameters.from(Map.of("key", "value"));
        Assertions.assertThat((Map)invocationParameters.asMap()).containsOnly(new Map.Entry[]{Map.entry("key", "value")});
    }

    @Test
    void test4() {
        HashMap<String, String> seedMap = new HashMap<String, String>();
        seedMap.put("key1", "value1");
        InvocationParameters invocationParameters = InvocationParameters.from(seedMap);
        Assertions.assertThat((Map)invocationParameters.asMap()).containsOnly(new Map.Entry[]{Map.entry("key1", "value1")});
        seedMap.put("key2", "value2");
        invocationParameters.put("key3", (Object)"value3");
        Assertions.assertThat(seedMap).containsOnlyKeys((Object[])new String[]{"key1", "key2"});
        Assertions.assertThat((Map)invocationParameters.asMap()).containsOnlyKeys((Object[])new String[]{"key1", "key3"});
    }
}

