/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.internal;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import dev.langchain4j.internal.JsonSchemaElementUtils;
import dev.langchain4j.model.chat.request.json.JsonObjectSchema;
import dev.langchain4j.model.chat.request.json.JsonRawSchema;
import dev.langchain4j.model.chat.request.json.JsonSchemaElement;
import dev.langchain4j.model.chat.request.json.JsonStringSchema;
import dev.langchain4j.model.output.structured.Description;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class JsonSchemaElementUtilsTest {
    JsonSchemaElementUtilsTest() {
    }

    @Test
    void is_custom_class() {
        Assertions.assertThat((boolean)JsonSchemaElementUtils.isCustomClass(CustomClass.class)).isTrue();
        Assertions.assertThat((boolean)JsonSchemaElementUtils.isCustomClass(Integer.class)).isFalse();
        Assertions.assertThat((boolean)JsonSchemaElementUtils.isCustomClass(LocalDateTime.class)).isFalse();
    }

    @Test
    void should_not_use_reference_schema_when_no_recursion() {
        Class<Order> clazz = Order.class;
        JsonSchemaElement jsonSchemaElement = JsonSchemaElementUtils.jsonSchemaElementFrom(clazz, null, null, (boolean)true, new LinkedHashMap());
        Assertions.assertThat((Object)jsonSchemaElement).isEqualTo((Object)JsonObjectSchema.builder().addProperty("billingAddress", (JsonSchemaElement)JsonObjectSchema.builder().addStringProperty("city").required(new String[]{"city"}).build()).addProperty("shippingAddress", (JsonSchemaElement)JsonObjectSchema.builder().addStringProperty("city").required(new String[]{"city"}).build()).required(new String[]{"billingAddress", "shippingAddress"}).build());
    }

    @Test
    void should_set_default_description_for_uuid() {
        Class<UUID> clazz = UUID.class;
        JsonSchemaElement jsonSchemaElement = JsonSchemaElementUtils.jsonSchemaElementFrom(clazz, null, null, (boolean)true, new LinkedHashMap());
        Assertions.assertThat((Object)jsonSchemaElement).isEqualTo((Object)JsonStringSchema.builder().description("String in a UUID format").build());
    }

    @Test
    void should_set_default_description_for_uuid_in_class() {
        Class<MyClassWithUuid> clazz = MyClassWithUuid.class;
        JsonSchemaElement jsonSchemaElement = JsonSchemaElementUtils.jsonSchemaElementFrom(clazz, null, null, (boolean)true, new LinkedHashMap());
        Assertions.assertThat((Object)jsonSchemaElement).isEqualTo((Object)JsonObjectSchema.builder().addStringProperty("uuid", "String in a UUID format").required(new String[]{"uuid"}).build());
    }

    @Test
    void should_use_non_null_description_for_uuid() {
        Class<MyClassWithDescribedUuid> clazz = MyClassWithDescribedUuid.class;
        JsonSchemaElement jsonSchemaElement = JsonSchemaElementUtils.jsonSchemaElementFrom(clazz, null, null, (boolean)true, new LinkedHashMap());
        Assertions.assertThat((Object)jsonSchemaElement).isEqualTo((Object)JsonObjectSchema.builder().addStringProperty("uuid", "My UUID").required(new String[]{"uuid"}).build());
    }

    @Test
    void givenVisitedJsonObjectSchema_whenDescriptionIsDifferent_thenReturnsNewSchemaWithUpdatedDescription() {
        JsonObjectSchema jsonObjectSchema = JsonObjectSchema.builder().description("old").addStringProperty("a").build();
        Map<Class<CustomClass>, JsonSchemaElementUtils.VisitedClassMetadata> visited = Map.of(CustomClass.class, new JsonSchemaElementUtils.VisitedClassMetadata((JsonSchemaElement)jsonObjectSchema, "ref-object", false));
        JsonSchemaElement result = JsonSchemaElementUtils.jsonObjectOrReferenceSchemaFrom(CustomClass.class, (String)"new", (boolean)false, visited, (boolean)false);
        Assertions.assertThat((Object)result).isNotSameAs((Object)jsonObjectSchema);
        Assertions.assertThat((String)result.description()).isEqualTo("new");
    }

    @Test
    void givenVisitedJsonObjectSchema_whenDescriptionIsSame_thenReturnsSameInstance() {
        JsonObjectSchema jsonObjectSchema = JsonObjectSchema.builder().description("same-desc").addStringProperty("a").build();
        Map<Class<CustomClass>, JsonSchemaElementUtils.VisitedClassMetadata> visited = Map.of(CustomClass.class, new JsonSchemaElementUtils.VisitedClassMetadata((JsonSchemaElement)jsonObjectSchema, "ref-object", false));
        JsonSchemaElement result = JsonSchemaElementUtils.jsonObjectOrReferenceSchemaFrom(CustomClass.class, (String)"same-desc", (boolean)false, visited, (boolean)false);
        Assertions.assertThat((Object)result).isSameAs((Object)jsonObjectSchema);
        Assertions.assertThat((String)result.description()).isEqualTo("same-desc");
    }

    @Test
    void toMap_not_strict() throws JsonProcessingException {
        JsonObjectSchema person = JsonObjectSchema.builder().addStringProperty("name").addStringProperty("age").required(new String[]{"name"}).build();
        Map map = JsonSchemaElementUtils.toMap((JsonSchemaElement)person, (boolean)false);
        Assertions.assertThat((String)new ObjectMapper().writeValueAsString((Object)map)).isEqualToIgnoringWhitespace((CharSequence)"{\n   \"type\":\"object\",\n   \"properties\":{\n      \"name\":{\n         \"type\":\"string\"\n      },\n      \"age\":{\n         \"type\":\"string\"\n      }\n   },\n   \"required\":[\n      \"name\"\n   ]\n}\n");
    }

    @Test
    void toMap_strict() throws JsonProcessingException {
        JsonObjectSchema person = JsonObjectSchema.builder().addStringProperty("name").addStringProperty("age").required(new String[]{"name"}).build();
        Map map = JsonSchemaElementUtils.toMap((JsonSchemaElement)person, (boolean)true);
        Assertions.assertThat((String)new ObjectMapper().writeValueAsString((Object)map)).isEqualToIgnoringWhitespace((CharSequence)"{\n   \"type\":\"object\",\n   \"properties\":{\n      \"name\":{\n         \"type\":\"string\"\n      },\n      \"age\":{\n         \"type\":[\"string\", \"null\"]\n      }\n   },\n   \"required\":[\n      \"name\", \"age\"\n   ],\n   \"additionalProperties\": false\n}\n");
    }

    @Test
    void nativeSchemaToMap() throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        String rawJsonSchema = "{\n    \"additionalProperties\": false,\n    \"type\" : \"object\",\n    \"properties\" : {\n      \"$schema\" : {\n        \"type\" : \"string\"\n      },\n      \"name\" : {\n        \"type\" : \"string\"\n      }\n    },\n    \"required\": [ \"name\" ]\n}\n";
        JsonRawSchema nativeJson = JsonRawSchema.from((String)rawJsonSchema);
        Map map = JsonSchemaElementUtils.toMap((JsonSchemaElement)nativeJson);
        ((AbstractStringAssert)Assertions.assertThat((String)mapper.writeValueAsString((Object)map)).as("injection of existing full-blown schemas as string are possible", new Object[0])).isEqualToIgnoringWhitespace((CharSequence)rawJsonSchema);
    }

    @Test
    void stringIsJsonCompatible() {
        Assertions.assertThat((boolean)JsonSchemaElementUtils.isJsonString(Character.TYPE)).isTrue();
        Assertions.assertThat((boolean)JsonSchemaElementUtils.isJsonString(String.class)).isTrue();
        Assertions.assertThat((boolean)JsonSchemaElementUtils.isJsonString(Character.class)).isTrue();
        Assertions.assertThat((boolean)JsonSchemaElementUtils.isJsonString(StringBuffer.class)).isTrue();
        Assertions.assertThat((boolean)JsonSchemaElementUtils.isJsonString(StringBuilder.class)).isTrue();
        Assertions.assertThat((boolean)JsonSchemaElementUtils.isJsonString(CharSequence.class)).isTrue();
        Assertions.assertThat((boolean)JsonSchemaElementUtils.isJsonString(UUID.class)).isTrue();
    }

    @Test
    void collectionIsJsonCompatible() {
        Assertions.assertThat((boolean)JsonSchemaElementUtils.isJsonArray(String[].class)).isTrue();
        Assertions.assertThat((boolean)JsonSchemaElementUtils.isJsonArray(Integer[].class)).isTrue();
        Assertions.assertThat((boolean)JsonSchemaElementUtils.isJsonArray(int[].class)).isTrue();
        Assertions.assertThat((boolean)JsonSchemaElementUtils.isJsonArray(List.class)).isTrue();
        Assertions.assertThat((boolean)JsonSchemaElementUtils.isJsonArray(Set.class)).isTrue();
        Assertions.assertThat((boolean)JsonSchemaElementUtils.isJsonArray(Deque.class)).isTrue();
        Assertions.assertThat((boolean)JsonSchemaElementUtils.isJsonArray(Collection.class)).isTrue();
        Assertions.assertThat((boolean)JsonSchemaElementUtils.isJsonArray(Iterable.class)).isTrue();
    }

    static class CustomClass {
        CustomClass() {
        }
    }

    static class Order {
        Address billingAddress;
        Address shippingAddress;

        Order() {
        }
    }

    static class MyClassWithUuid {
        UUID uuid;

        MyClassWithUuid() {
        }
    }

    static class MyClassWithDescribedUuid {
        @Description(value={"My UUID"})
        UUID uuid;

        MyClassWithDescribedUuid() {
        }
    }

    static class Address {
        String city;

        Address() {
        }
    }
}

