/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.internal;

import dev.langchain4j.internal.JsonParsingUtils;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.junit.jupiter.api.Test;

class JsonParsingUtilsTest {
    JsonParsingUtilsTest() {
    }

    @Test
    void extract_simple_object() {
        String json = "{\"name\":\"Tom\",\"age\":18}";
        Optional result = JsonParsingUtils.extractAndParseJson((String)json, MyPojo.class);
        Assertions.assertThat((Optional)result).isPresent();
        Assertions.assertThat((String)((MyPojo)((JsonParsingUtils.ParsedJson)result.get()).value()).name).isEqualTo("Tom");
        Assertions.assertThat((int)((MyPojo)((JsonParsingUtils.ParsedJson)result.get()).value()).age).isEqualTo(18);
    }

    @Test
    void extract_object_with_prefix_suffix() {
        String json = "prefix {\"name\":\"Jerry\",\"age\":20} suffix";
        Optional result = JsonParsingUtils.extractAndParseJson((String)json, MyPojo.class);
        Assertions.assertThat((Optional)result).isPresent();
        Assertions.assertThat((String)((MyPojo)((JsonParsingUtils.ParsedJson)result.get()).value()).name).isEqualTo("Jerry");
        Assertions.assertThat((int)((MyPojo)((JsonParsingUtils.ParsedJson)result.get()).value()).age).isEqualTo(20);
    }

    @Test
    void extract_array() {
        String json = "[{\"name\":\"A\",\"age\":1},{\"name\":\"B\",\"age\":2}]";
        Optional result = JsonParsingUtils.extractAndParseJson((String)json, MyPojo[].class);
        Assertions.assertThat((Optional)result).isPresent();
        Assertions.assertThat((int)((MyPojo[])((JsonParsingUtils.ParsedJson)result.get()).value()).length).isEqualTo(2);
        Assertions.assertThat((String)((MyPojo[])((JsonParsingUtils.ParsedJson)result.get()).value())[0].name).isEqualTo("A");
        Assertions.assertThat((int)((MyPojo[])((JsonParsingUtils.ParsedJson)result.get()).value())[1].age).isEqualTo(2);
    }

    @Test
    void extract_array_with_noise() {
        String json = "abc [{\"name\":\"A\",\"age\":1},{\"name\":\"B\",\"age\":2}] xyz";
        Optional result = JsonParsingUtils.extractAndParseJson((String)json, MyPojo[].class);
        Assertions.assertThat((Optional)result).isPresent();
        Assertions.assertThat((int)((MyPojo[])((JsonParsingUtils.ParsedJson)result.get()).value()).length).isEqualTo(2);
    }

    @Test
    void extract_nested_array() {
        String json = "[[{\"name\":\"A\",\"age\":1}],[{\"name\":\"B\",\"age\":2}]]";
        Optional result = JsonParsingUtils.extractAndParseJson((String)json, MyPojo[][].class);
        Assertions.assertThat((Optional)result).isPresent();
        Assertions.assertThat((int)((MyPojo[][])((JsonParsingUtils.ParsedJson)result.get()).value()).length).isEqualTo(2);
        Assertions.assertThat((String)((MyPojo[][])((JsonParsingUtils.ParsedJson)result.get()).value())[0][0].name).isEqualTo("A");
        Assertions.assertThat((String)((MyPojo[][])((JsonParsingUtils.ParsedJson)result.get()).value())[1][0].name).isEqualTo("B");
    }

    @Test
    void extract_object_with_array_field() {
        String json = "{\"name\":\"Tom\",\"age\":18,\"tags\":[\"a\",\"b\"]}";
        Optional result = JsonParsingUtils.extractAndParseJson((String)json, MyPojo.class);
        Assertions.assertThat((Optional)result).isPresent();
        Assertions.assertThat(((MyPojo)((JsonParsingUtils.ParsedJson)result.get()).value()).tags).containsExactly((Object[])new String[]{"a", "b"});
    }

    @Test
    void extract_object_with_map_field() {
        String json = "{\"name\":\"Tom\",\"age\":18,\"extra\":{\"k1\":123,\"k2\":\"v2\"}}";
        Optional result = JsonParsingUtils.extractAndParseJson((String)json, MyPojo.class);
        Assertions.assertThat((Optional)result).isPresent();
        ((MapAssert)Assertions.assertThat(((MyPojo)((JsonParsingUtils.ParsedJson)result.get()).value()).extra).containsEntry((Object)"k1", (Object)123)).containsEntry((Object)"k2", (Object)"v2");
    }

    @Test
    void extract_multiple_json_blocks() {
        String json = "foo {\"name\":\"A\",\"age\":1} bar {\"name\":\"B\",\"age\":2}";
        Optional result = JsonParsingUtils.extractAndParseJson((String)json, MyPojo.class);
        Assertions.assertThat((Optional)result).isPresent();
        Assertions.assertThat((String)((MyPojo)((JsonParsingUtils.ParsedJson)result.get()).value()).name).isEqualTo("B");
    }

    @Test
    void extract_invalid_json() {
        String json = "not a json";
        Optional result = JsonParsingUtils.extractAndParseJson((String)json, MyPojo.class);
        Assertions.assertThat((Optional)result).isEmpty();
    }

    @Test
    void extract_json_with_inner_brackets() {
        String json = "{\"name\":\"Tom\",\"age\":18,\"tags\":[\"a\",\"b\",\"[c]\"]}";
        Optional result = JsonParsingUtils.extractAndParseJson((String)json, MyPojo.class);
        Assertions.assertThat((Optional)result).isPresent();
        Assertions.assertThat(((MyPojo)((JsonParsingUtils.ParsedJson)result.get()).value()).tags).contains((Object[])new String[]{"[c]"});
    }

    @Test
    void extract_json_array_with_nested_objects_and_arrays() {
        String json = "[{\"name\":\"Tom\",\"age\":18,\"tags\":[\"a\",\"b\"]},{\"name\":\"Jerry\",\"age\":20,\"tags\":[\"x\",\"y\"]}]";
        Optional result = JsonParsingUtils.extractAndParseJson((String)json, MyPojo[].class);
        Assertions.assertThat((Optional)result).isPresent();
        Assertions.assertThat(((MyPojo[])((JsonParsingUtils.ParsedJson)result.get()).value())[1].tags).containsExactly((Object[])new String[]{"x", "y"});
    }

    static class MyPojo {
        public String name;
        public int age;
        public List<String> tags;
        public Map<String, Object> extra;

        public MyPojo() {
        }

        public MyPojo(String name, int age) {
            this.name = name;
            this.age = age;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MyPojo myPojo = (MyPojo)o;
            return this.age == myPojo.age && Objects.equals(this.name, myPojo.name);
        }
    }
}

