/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.guardrail;

import com.fasterxml.jackson.core.type.TypeReference;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.guardrail.GuardrailResult;
import dev.langchain4j.guardrail.JsonExtractorOutputGuardrail;
import dev.langchain4j.guardrail.OutputGuardrailResult;
import dev.langchain4j.test.guardrail.GuardrailAssertions;
import dev.langchain4j.test.guardrail.OutputGuardrailResultAssert;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.Mockito;

class JsonExtractorOutputGuardrailTests {
    private static final String JSON = "{\n    \"name\": \"MyObject\",\n    \"description\": \"Description of MyObject\"\n}";
    private static final JsonExtractorOutputGuardrail<MyObject> MY_OBJECT_JSON_OUTPUT_GUARDRAIL = new JsonExtractorOutputGuardrail(MyObject.class);
    private static final JsonExtractorOutputGuardrail<Map<String, MyObject>> MAP_OF_MY_OBJECT_JSON_OUTPUT_GUARDRAIL = new JsonExtractorOutputGuardrail((TypeReference)new TypeReference<Map<String, MyObject>>(){});

    JsonExtractorOutputGuardrailTests() {
    }

    @ParameterizedTest
    @MethodSource(value={"guardrails"})
    void successfulValidation(String json, JsonExtractorOutputGuardrail<?> guardrail, Object expectedResult) {
        JsonExtractorOutputGuardrail guardrailSpy = (JsonExtractorOutputGuardrail)Mockito.spy(guardrail);
        OutputGuardrailResult result = guardrailSpy.validate(AiMessage.from((String)json));
        ((OutputGuardrailResultAssert)GuardrailAssertions.assertThat(result).isNotNull()).extracting(new Function[]{OutputGuardrailResult::result, OutputGuardrailResult::successfulText, OutputGuardrailResult::successfulResult}).containsExactly(new Object[]{GuardrailResult.Result.SUCCESS_WITH_RESULT, json, expectedResult});
        ((JsonExtractorOutputGuardrail)Mockito.verify((Object)guardrailSpy)).deserialize(json);
    }

    @ParameterizedTest
    @MethodSource(value={"guardrails"})
    void successfulValidationAfterTrimming(String json, JsonExtractorOutputGuardrail<?> guardrail, Object expectedResult) {
        String input = "abc" + json;
        this.parseJsonRequiringTrimming(json, guardrail, expectedResult, input);
    }

    @ParameterizedTest
    @MethodSource(value={"guardrails"})
    void successfulValidationAfterTrimmingWithInvalidJson(String json, JsonExtractorOutputGuardrail<?> guardrail, Object expectedResult) {
        String input = "abc [test] {\"key\":\"value\"} " + json + " [another] xyz";
        this.parseJsonRequiringTrimming(json, guardrail, expectedResult, input);
    }

    private void parseJsonRequiringTrimming(String json, JsonExtractorOutputGuardrail<?> guardrail, Object expectedResult, String input) {
        JsonExtractorOutputGuardrail guardrailSpy = (JsonExtractorOutputGuardrail)Mockito.spy(guardrail);
        OutputGuardrailResult result = guardrailSpy.validate(AiMessage.from((String)input));
        ((OutputGuardrailResultAssert)GuardrailAssertions.assertThat(result).isNotNull()).extracting(new Function[]{OutputGuardrailResult::result, OutputGuardrailResult::successfulText, OutputGuardrailResult::successfulResult}).containsExactly(new Object[]{GuardrailResult.Result.SUCCESS_WITH_RESULT, json, expectedResult});
        ((JsonExtractorOutputGuardrail)Mockito.verify((Object)guardrailSpy)).deserialize(input);
    }

    @Test
    void invalidJson() {
        JsonExtractorOutputGuardrail guardrail = (JsonExtractorOutputGuardrail)Mockito.spy(MY_OBJECT_JSON_OUTPUT_GUARDRAIL);
        String input = "{{{\n    \"name\": \"MyObject\",\n    \"description\": \"Description of MyObject\"\n}";
        OutputGuardrailResult result = guardrail.validate(AiMessage.from((String)input));
        GuardrailAssertions.assertThat(result).hasSingleFailureWithMessageAndReprompt("Invalid JSON", "Make sure you return a valid JSON object following the specified format");
        ((JsonExtractorOutputGuardrail)Mockito.verify((Object)guardrail)).deserialize(input);
        ((JsonExtractorOutputGuardrail)Mockito.verify((Object)guardrail)).invokeInvalidJson((AiMessage)Mockito.any(AiMessage.class), (String)Mockito.eq((Object)input));
    }

    static Stream<Arguments> guardrails() {
        MyObject result = new MyObject("MyObject", "Description of MyObject");
        return Stream.of(Arguments.of((Object[])new Object[]{JSON, MY_OBJECT_JSON_OUTPUT_GUARDRAIL, result}), Arguments.of((Object[])new Object[]{"{ \"myObject\": %s}".formatted(JSON), MAP_OF_MY_OBJECT_JSON_OUTPUT_GUARDRAIL, Map.of("myObject", result)}));
    }

    record MyObject(String name, String description) {
    }
}

