/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.data.audio;

import dev.langchain4j.data.audio.Audio;
import java.net.URI;
import java.util.Base64;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class AudioTest {
    AudioTest() {
    }

    @Test
    void should_create_audio_with_binary_data() {
        byte[] binaryData = "test audio data".getBytes();
        String mimeType = "audio/wav";
        Audio audio = Audio.builder().binaryData(binaryData).mimeType(mimeType).build();
        Assertions.assertThat((byte[])audio.binaryData()).isEqualTo((Object)binaryData);
        Assertions.assertThat((String)audio.mimeType()).isEqualTo(mimeType);
        Assertions.assertThat((String)audio.base64Data()).isNull();
        Assertions.assertThat((URI)audio.url()).isNull();
    }

    @Test
    void should_create_audio_with_base64_data() {
        String base64Data = Base64.getEncoder().encodeToString("test audio data".getBytes());
        String mimeType = "audio/mp3";
        Audio audio = Audio.builder().base64Data(base64Data).mimeType(mimeType).build();
        Assertions.assertThat((String)audio.base64Data()).isEqualTo(base64Data);
        Assertions.assertThat((String)audio.mimeType()).isEqualTo(mimeType);
        Assertions.assertThat((byte[])audio.binaryData()).isNull();
        Assertions.assertThat((URI)audio.url()).isNull();
    }

    @Test
    void should_create_audio_with_url() {
        String urlString = "https://example.com/audio.wav";
        String mimeType = "audio/wav";
        Audio audio = Audio.builder().url(urlString).mimeType(mimeType).build();
        Assertions.assertThat((URI)audio.url()).isEqualTo((Object)URI.create(urlString));
        Assertions.assertThat((String)audio.mimeType()).isEqualTo(mimeType);
        Assertions.assertThat((byte[])audio.binaryData()).isNull();
        Assertions.assertThat((String)audio.base64Data()).isNull();
    }

    @Test
    void should_create_audio_with_uri() {
        URI uri = URI.create("https://example.com/audio.wav");
        String mimeType = "audio/wav";
        Audio audio = Audio.builder().url(uri).mimeType(mimeType).build();
        Assertions.assertThat((URI)audio.url()).isEqualTo((Object)uri);
        Assertions.assertThat((String)audio.mimeType()).isEqualTo(mimeType);
        Assertions.assertThat((byte[])audio.binaryData()).isNull();
        Assertions.assertThat((String)audio.base64Data()).isNull();
    }

    @Test
    void should_be_equal_when_same_content() {
        byte[] data = "test".getBytes();
        Audio audio1 = Audio.builder().binaryData(data).mimeType("audio/wav").build();
        Audio audio2 = Audio.builder().binaryData(data).mimeType("audio/wav").build();
        Assertions.assertThat((Object)audio1).isEqualTo((Object)audio2);
        Assertions.assertThat((int)audio1.hashCode()).isEqualTo(audio2.hashCode());
    }

    @Test
    void should_not_be_equal_when_different_content() {
        Audio audio1 = Audio.builder().binaryData("test1".getBytes()).mimeType("audio/wav").build();
        Audio audio2 = Audio.builder().binaryData("test2".getBytes()).mimeType("audio/wav").build();
        Assertions.assertThat((Object)audio1).isNotEqualTo((Object)audio2);
    }

    @Test
    void should_not_be_equal_to_null() {
        Audio audio = Audio.builder().binaryData("test".getBytes()).mimeType("audio/wav").build();
        Assertions.assertThat((Object)audio).isNotEqualTo(null);
    }

    @Test
    void should_not_be_equal_to_different_class() {
        Audio audio = Audio.builder().binaryData("test".getBytes()).mimeType("audio/wav").build();
        Assertions.assertThat((Object)audio).isNotEqualTo((Object)"not an audio");
    }

    @Test
    void should_have_proper_toString() {
        Audio audio = Audio.builder().url("https://example.com/audio.wav").base64Data("dGVzdA==").mimeType("audio/wav").build();
        String toString = audio.toString();
        Assertions.assertThat((String)toString).contains(new CharSequence[]{"Audio"});
        Assertions.assertThat((String)toString).contains(new CharSequence[]{"url"});
        Assertions.assertThat((String)toString).contains(new CharSequence[]{"base64Data"});
        Assertions.assertThat((String)toString).contains(new CharSequence[]{"mimeType"});
    }

    @Test
    void should_handle_file_protocol_url() {
        Audio audio = Audio.builder().url("file:///home/user/audio.wav").mimeType("audio/wav").build();
        Assertions.assertThat((String)audio.url().toString()).isEqualTo("file:///home/user/audio.wav");
        Assertions.assertThat((String)audio.mimeType()).isEqualTo("audio/wav");
    }
}

