/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.embedding.listener;

import dev.langchain4j.Experimental;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.embedding.EmbeddingModel;
import java.util.List;
import java.util.Map;

@Experimental
public class EmbeddingModelRequestContext {
    private final List<TextSegment> textSegments;
    private final EmbeddingModel embeddingModel;
    private final Map<Object, Object> attributes;

    public EmbeddingModelRequestContext(Builder builder) {
        this.textSegments = Utils.copy(ValidationUtils.ensureNotNull(builder.textSegments, "textSegments"));
        this.embeddingModel = ValidationUtils.ensureNotNull(builder.embeddingModel, "embeddingModel");
        this.attributes = ValidationUtils.ensureNotNull(builder.attributes, "attributes");
    }

    public static Builder builder() {
        return new Builder();
    }

    public List<TextSegment> textSegments() {
        return this.textSegments;
    }

    public EmbeddingModel embeddingModel() {
        return this.embeddingModel;
    }

    public Map<Object, Object> attributes() {
        return this.attributes;
    }

    @Experimental
    public static class Builder {
        private List<TextSegment> textSegments;
        private EmbeddingModel embeddingModel;
        private Map<Object, Object> attributes;

        Builder() {
        }

        public Builder textSegments(List<TextSegment> textSegments) {
            this.textSegments = textSegments;
            return this;
        }

        public Builder embeddingModel(EmbeddingModel embeddingModel) {
            this.embeddingModel = embeddingModel;
            return this;
        }

        public Builder attributes(Map<Object, Object> attributes) {
            this.attributes = attributes;
            return this;
        }

        public EmbeddingModelRequestContext build() {
            return new EmbeddingModelRequestContext(this);
        }
    }
}

