/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.rag.content.retriever;

import dev.langchain4j.rag.content.retriever.WebSearchContentRetriever;
import dev.langchain4j.rag.query.Query;
import dev.langchain4j.web.search.WebSearchEngine;
import java.util.List;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.Test;

public abstract class WebSearchContentRetrieverIT {
    protected abstract WebSearchEngine searchEngine();

    @Test
    void should_retrieve_web_page_as_content() {
        WebSearchContentRetriever contentRetriever = WebSearchContentRetriever.builder().webSearchEngine(this.searchEngine()).build();
        Query query = Query.from((String)"What is the current weather in New York?");
        List contents = contentRetriever.retrieve(query);
        ((ListAssert)Assertions.assertThat((List)contents).as("At least one content should be contains 'weather' and 'New York' ignoring case", new Object[0])).anySatisfy(content -> {
            ((AbstractStringAssert)Assertions.assertThat((String)content.textSegment().text()).containsIgnoringCase((CharSequence)"weather")).containsIgnoringCase((CharSequence)"New York");
            Assertions.assertThat((String)content.textSegment().metadata().getString("url")).startsWith((CharSequence)"https://");
        });
    }
}

