/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.rag.content.aggregator;

import dev.langchain4j.rag.content.Content;
import dev.langchain4j.rag.content.aggregator.ReciprocalRankFuser;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class ReciprocalRankFuserTest {
    private static final Content A = Content.from((String)"A");
    private static final Content B = Content.from((String)"B");
    private static final Content C = Content.from((String)"C");
    private static final Content D = Content.from((String)"D");

    ReciprocalRankFuserTest() {
    }

    @ParameterizedTest
    @MethodSource
    void should_fuse(Collection<List<Content>> contents, List<Content> expected) {
        Assertions.assertThat((List)ReciprocalRankFuser.fuse(contents)).isEqualTo(expected);
    }

    public static Stream<Arguments> should_fuse() {
        return Stream.builder().add(Arguments.of((Object[])new Object[]{Arrays.asList(ReciprocalRankFuserTest.list(new Content[0]), ReciprocalRankFuserTest.list(new Content[0])), ReciprocalRankFuserTest.list(new Content[0])})).add(Arguments.of((Object[])new Object[]{Arrays.asList(ReciprocalRankFuserTest.list(new Content[0]), ReciprocalRankFuserTest.list(A)), ReciprocalRankFuserTest.list(A)})).add(Arguments.of((Object[])new Object[]{Arrays.asList(ReciprocalRankFuserTest.list(A), ReciprocalRankFuserTest.list(new Content[0])), ReciprocalRankFuserTest.list(A)})).add(Arguments.of((Object[])new Object[]{Arrays.asList(ReciprocalRankFuserTest.list(A), ReciprocalRankFuserTest.list(A)), ReciprocalRankFuserTest.list(A)})).add(Arguments.of((Object[])new Object[]{Arrays.asList(ReciprocalRankFuserTest.list(A), ReciprocalRankFuserTest.list(B)), Arrays.asList(A, B)})).add(Arguments.of((Object[])new Object[]{Arrays.asList(ReciprocalRankFuserTest.list(A), ReciprocalRankFuserTest.list(A, B)), Arrays.asList(A, B)})).add(Arguments.of((Object[])new Object[]{Arrays.asList(ReciprocalRankFuserTest.list(A), ReciprocalRankFuserTest.list(B, A)), Arrays.asList(A, B)})).add(Arguments.of((Object[])new Object[]{Arrays.asList(ReciprocalRankFuserTest.list(A, B), ReciprocalRankFuserTest.list(A)), Arrays.asList(A, B)})).add(Arguments.of((Object[])new Object[]{Arrays.asList(ReciprocalRankFuserTest.list(A, B), ReciprocalRankFuserTest.list(B)), Arrays.asList(B, A)})).add(Arguments.of((Object[])new Object[]{Arrays.asList(ReciprocalRankFuserTest.list(A, B), ReciprocalRankFuserTest.list(A, B)), Arrays.asList(A, B)})).add(Arguments.of((Object[])new Object[]{Arrays.asList(ReciprocalRankFuserTest.list(A, B), ReciprocalRankFuserTest.list(B, A)), Arrays.asList(A, B)})).add(Arguments.of((Object[])new Object[]{Arrays.asList(ReciprocalRankFuserTest.list(A, B), ReciprocalRankFuserTest.list(A, C)), Arrays.asList(A, B, C)})).add(Arguments.of((Object[])new Object[]{Arrays.asList(ReciprocalRankFuserTest.list(A, B), ReciprocalRankFuserTest.list(B, C)), Arrays.asList(B, A, C)})).add(Arguments.of((Object[])new Object[]{Arrays.asList(ReciprocalRankFuserTest.list(A, B), ReciprocalRankFuserTest.list(C, D)), Arrays.asList(A, C, B, D)})).build();
    }

    private static List<Content> list(Content ... contents) {
        return Arrays.asList(contents);
    }
}

