/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.chat.request;

import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.model.chat.request.ChatRequest;
import dev.langchain4j.model.chat.request.ChatRequestParameters;
import dev.langchain4j.model.chat.request.ResponseFormat;
import java.util.List;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class ChatRequestTest {
    ChatRequestTest() {
    }

    @Test
    void should_keep_backward_compatibility() {
        UserMessage userMessage = UserMessage.from((String)"hi");
        ToolSpecification toolSpecification = ToolSpecification.builder().name("tool").build();
        ResponseFormat responseFormat = ResponseFormat.JSON;
        ChatRequest chatRequest = ChatRequest.builder().messages(new ChatMessage[]{userMessage}).toolSpecifications(new ToolSpecification[]{toolSpecification}).responseFormat(responseFormat).build();
        Assertions.assertThat((List)chatRequest.messages()).containsExactly((Object[])new ChatMessage[]{userMessage});
        Assertions.assertThat((List)chatRequest.toolSpecifications()).containsExactly((Object[])new ToolSpecification[]{toolSpecification});
        Assertions.assertThat((Object)chatRequest.responseFormat()).isEqualTo((Object)responseFormat);
    }

    @Test
    void should_set_messages_and_request_parameters() {
        UserMessage userMessage = UserMessage.from((String)"hi");
        ToolSpecification toolSpecification = ToolSpecification.builder().name("tool").build();
        ResponseFormat responseFormat = ResponseFormat.JSON;
        ChatRequestParameters parameters = ChatRequestParameters.builder().toolSpecifications(new ToolSpecification[]{toolSpecification}).responseFormat(responseFormat).build();
        ChatRequest chatRequest = ChatRequest.builder().messages(new ChatMessage[]{userMessage}).parameters(parameters).build();
        Assertions.assertThat((List)chatRequest.messages()).containsExactly((Object[])new ChatMessage[]{userMessage});
        Assertions.assertThat((Object)chatRequest.parameters()).isEqualTo((Object)parameters);
        Assertions.assertThat((List)chatRequest.toolSpecifications()).containsExactly((Object[])new ToolSpecification[]{toolSpecification});
        Assertions.assertThat((Object)chatRequest.responseFormat()).isEqualTo((Object)responseFormat);
    }

    @Test
    void should_fail_when_both_request_parameters_and_response_format_are_set() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ChatRequest.builder().messages(new ChatMessage[]{UserMessage.from((String)"hi")}).parameters(ChatRequestParameters.builder().build()).responseFormat(ResponseFormat.JSON).build()).isExactlyInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot set both 'parameters' and 'responseFormat' on ChatRequest");
    }

    @Test
    void should_fail_when_both_request_parameters_and_toolSpecifications_are_set() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ChatRequest.builder().messages(new ChatMessage[]{UserMessage.from((String)"hi")}).parameters(ChatRequestParameters.builder().build()).toolSpecifications(new ToolSpecification[]{ToolSpecification.builder().name("tool").build()}).build()).isExactlyInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot set both 'parameters' and 'toolSpecifications' on ChatRequest");
    }
}

