/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.chat.common;

import dev.langchain4j.model.chat.StreamingChatModel;
import dev.langchain4j.model.chat.common.AbstractBaseChatModelIT;
import dev.langchain4j.model.chat.common.ChatResponseAndStreamingMetadata;
import dev.langchain4j.model.chat.common.StreamingMetadata;
import dev.langchain4j.model.chat.request.ChatRequest;
import dev.langchain4j.model.chat.response.ChatResponse;
import dev.langchain4j.model.chat.response.StreamingChatResponseHandler;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public abstract class AbstractStreamingChatModelIT
extends AbstractBaseChatModelIT<StreamingChatModel> {
    @Override
    protected ChatResponseAndStreamingMetadata chat(StreamingChatModel chatModel, ChatRequest chatRequest) {
        final CompletableFuture futureChatResponse = new CompletableFuture();
        final StringBuffer concatenatedPartialResponsesBuilder = new StringBuffer();
        final AtomicInteger timesOnPartialResponseWasCalled = new AtomicInteger();
        final AtomicInteger timesOnCompleteResponseWasCalled = new AtomicInteger();
        final CopyOnWriteArraySet<Thread> threads = new CopyOnWriteArraySet<Thread>();
        chatModel.chat(chatRequest, new StreamingChatResponseHandler(){

            public void onPartialResponse(String partialResponse) {
                concatenatedPartialResponsesBuilder.append(partialResponse);
                timesOnPartialResponseWasCalled.incrementAndGet();
                threads.add(Thread.currentThread());
            }

            public void onCompleteResponse(ChatResponse completeResponse) {
                futureChatResponse.complete(completeResponse);
                timesOnCompleteResponseWasCalled.incrementAndGet();
                threads.add(Thread.currentThread());
            }

            public void onError(Throwable error) {
                futureChatResponse.completeExceptionally(error);
                threads.add(Thread.currentThread());
            }
        });
        try {
            ChatResponse chatResponse = (ChatResponse)futureChatResponse.get(120L, TimeUnit.SECONDS);
            String concatenatedPartialResponses = concatenatedPartialResponsesBuilder.toString();
            StreamingMetadata metadata = new StreamingMetadata(concatenatedPartialResponses.isEmpty() ? null : concatenatedPartialResponses, timesOnPartialResponseWasCalled.get(), timesOnCompleteResponseWasCalled.get(), threads);
            return new ChatResponseAndStreamingMetadata(chatResponse, metadata);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

